/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.MatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.SimpleWindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.Window;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;

public abstract class WindowMatrixProcess
extends MatrixProcess {
    private Window window;
    private Pixel pixel;

    public WindowMatrixProcess(Window w, Pixel p, WindowMatrixProcessType wpt) {
        super(wpt);
        this.window = w;
        this.pixel = p;
    }

    public String toString() {
        return this.pixel.toString();
    }

    @Override
    public WindowMatrixProcessType processType() {
        return (WindowMatrixProcessType)super.processType();
    }

    @Override
    public int compareTo(Process other) {
        if (other instanceof SimpleWindowMatrixProcess) {
            if (((WindowMatrixProcess)other).pixel.y() > this.pixel.y()) {
                return -1;
            }
            if (((WindowMatrixProcess)other).pixel.y() < this.pixel.y()) {
                return 1;
            }
            if (((WindowMatrixProcess)other).pixel.x() > this.pixel.x()) {
                return -1;
            }
            if (((WindowMatrixProcess)other).pixel.x() < this.pixel.x()) {
                return 1;
            }
            return this.window.compareTo(((WindowMatrixProcess)other).window);
        }
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && ((WindowMatrixProcess)other).pixel.y() == this.pixel.y() && ((WindowMatrixProcess)other).pixel.x() == this.pixel.x() && ((WindowMatrixProcess)other).window.equals(this.window);
    }

    public Window window() {
        return this.window;
    }

    public int width() {
        return this.window.width();
    }

    public int height() {
        return this.window.height();
    }

    public Pixel pixel() {
        return this.pixel;
    }

    protected void setPixel(Pixel p) {
        this.pixel = p;
    }

    public int x() {
        return this.pixel.x();
    }

    public int y() {
        return this.pixel.y();
    }

    public abstract boolean add(int var1, int var2, double var3);

    public abstract void down(int var1);
}

