/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.MatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingFactory;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetric;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;

public abstract class MatrixProcess
extends Process<MatrixMetric> {
    protected Counting counting;
    private int maxSize;
    private int currentSize = 0;

    public MatrixProcess() {
    }

    public MatrixProcess(MatrixProcessType pt) {
        super(pt);
    }

    public boolean equals(Object other) {
        if (other instanceof MatrixProcess) {
            return ((MatrixProcess)other).processType().equals(this.processType());
        }
        return false;
    }

    public MatrixProcessType processType() {
        return (MatrixProcessType)super.processType();
    }

    public Counting counting() {
        return this.counting;
    }

    public void init() {
        if (this.state().equals((Object)ProcessState.IDLE)) {
            this.counting = CountingFactory.create(this);
            this.counting.init();
            this.setState(ProcessState.INIT);
        }
    }

    public void delete() {
        this.counting.delete();
        this.counting = null;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int s) {
        this.maxSize = s;
    }

    public int currentSize() {
        return this.currentSize;
    }

    public void addCurrentSize() {
        ++this.currentSize;
    }

    public void minusCurrentSize() {
        if (this.currentSize > 0) {
            --this.currentSize;
        }
    }

    public void calculateMetrics() {
        if (this.state() == ProcessState.READY || this.state() == ProcessState.FINISH) {
            for (MatrixMetric m : this.processType().metrics()) {
                m.calculate(this, "");
            }
            this.setState(ProcessState.DONE);
        }
    }

    public void unCalculateMetrics() {
        if (this.state() == ProcessState.READY || this.state() == ProcessState.FINISH) {
            for (MatrixMetric m : this.processType().metrics()) {
                m.unCalculate(this, "");
            }
            this.setState(ProcessState.DONE);
        }
    }
}

