/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.MultipleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.SimpleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.Window;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.MetricOutput;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelWithID;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.CoordinateManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SelectedCsvOutput
extends AbstractMetricOutput
implements MetricOutput {
    private CsvWriter out;
    private Matrix matrix;
    private String file;
    private Set<Pixel> pixels;
    private Map<Pixel, Map<String, Double>> values;
    private int metricSize;

    public SelectedCsvOutput(Matrix m, String f, Set<Pixel> p) {
        this.matrix = m;
        this.file = f;
        this.pixels = p;
        this.values = new TreeMap<Pixel, Map<String, Double>>();
    }

    public String toString() {
        return "csv";
    }

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)ma);
                break;
            }
            case RUNNING: {
                this.notifyAnalysisRun((WindowMatrixAnalysis)ma);
                break;
            }
            case FINISH: {
                this.notifyAnalysisFinish((WindowMatrixAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis a) {
        this.out = new CsvWriter(this.file);
        this.out.setDelimiter(';');
    }

    private void notifyAnalysisRun(WindowMatrixAnalysis a) {
        TreeSet<String> columns = new TreeSet<String>();
        if (a.window() instanceof MultipleWindow) {
            for (Window w : ((MultipleWindow)a.window()).windows()) {
                for (Metric metric : a.metrics()) {
                    columns.add("w" + ((SimpleWindow)w).diameter() + "_" + metric.getName());
                }
            }
        } else {
            for (Metric metric : a.metrics()) {
                columns.add(metric.getName());
            }
        }
        try {
            if (this.pixels.iterator().next() instanceof PixelWithID) {
                this.out.write("id");
            }
            this.out.write("X");
            this.out.write("Y");
            for (String string : columns) {
                this.out.write(string);
            }
            this.out.endRecord();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyAnalysisFinish(WindowMatrixAnalysis a) {
        this.metricSize = this.values.values().iterator().next().keySet().size();
        for (Pixel p : this.pixels) {
            this.write(p);
        }
        this.out.close();
    }

    private void write(Pixel p) {
        try {
            if (p instanceof PixelWithID) {
                this.out.write(((PixelWithID)p).getId());
                this.out.write(((PixelWithID)p).getX() + "");
                this.out.write(((PixelWithID)p).getY() + "");
            } else {
                this.out.write(CoordinateManager.getProjectedX(this.matrix, p.x()) + "");
                this.out.write(CoordinateManager.getProjectedY(this.matrix, p.y()) + "");
            }
            if (this.values.containsKey(p)) {
                Map<String, Double> val = this.values.get(p);
                for (String v : val.keySet()) {
                    this.out.write(this.format(val.get(v)));
                }
            } else {
                for (int i = 0; i < this.metricSize; ++i) {
                    this.out.write(Raster.getNoDataValue() + "");
                }
            }
            this.out.endRecord();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void notify(Metric m, String metric, double v, Process wp) {
        if (this.pixels.contains(((WindowMatrixProcess)wp).pixel())) {
            this.values.get(((WindowMatrixProcess)wp).pixel()).put(metric, v);
        } else {
            m.removeObserver(this);
        }
    }

    @Override
    public void notify(Process p, ProcessState s) {
        if (p instanceof WindowMatrixProcess) {
            switch (s) {
                case INIT: {
                    this.notifyProcessInit((WindowMatrixProcess)p);
                }
            }
        }
    }

    private void notifyProcessInit(WindowMatrixProcess wp) {
        if (this.pixels.contains(wp.pixel())) {
            this.values.put(wp.pixel(), new TreeMap());
        }
    }
}

