/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;
import java.util.Set;

public class ChamferDistance
extends MatrixCalculation {
    private static final int[][] chamfer13 = new int[][]{{1, 0, 68}, {1, 1, 96}, {2, 1, 152}, {3, 1, 215}, {3, 2, 245}, {4, 1, 280}, {4, 3, 340}, {5, 1, 346}, {6, 1, 413}};
    private int[][] chamfer = chamfer13;
    private int normalizer = this.chamfer[0][2];
    private int width = 0;
    private int height = 0;
    private Matrix matrix;
    private Set<Integer> codes;

    public ChamferDistance(Matrix input, Set<Integer> codes) {
        super(input);
        this.matrix = input;
        this.codes = codes;
    }

    @Override
    protected void doRun() {
        this.setResult(this.compute(this.matrix, this.codes));
    }

    private void testAndSet(Matrix output, int x, int y, double newvalue) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        double v = output.get(x, y);
        if (v >= 0.0 && v < newvalue) {
            return;
        }
        output.put(x, y, newvalue);
    }

    private void testAndSet(double[][] output, int x, int y, double newvalue) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        double v = output[x][y];
        if (v >= 0.0 && v < newvalue) {
            return;
        }
        output[x][y] = newvalue;
    }

    private Matrix compute(Matrix input, Set<Integer> codes) {
        int[] tab = new int[codes.size()];
        int index = 0;
        for (int i : codes) {
            tab[index++] = i;
        }
        return this.compute(input, tab);
    }

    private Matrix compute(Matrix input, int ... code) {
        int dt;
        int dy;
        int k;
        double v;
        int x;
        int y;
        Matrix output = MatrixFactory.get(input.getType()).create(input.width(), input.height(), input.cellsize(), input.minX(), input.maxX(), input.minY(), input.maxY(), input.noDataValue());
        this.width = input.width();
        this.height = input.height();
        int total = this.width * this.height * 4;
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                v = input.get(x, y);
                boolean ok = false;
                for (int c : code) {
                    if ((double)c != v) continue;
                    ok = true;
                    break;
                }
                if (ok) {
                    output.put(x, y, 0.0);
                } else {
                    output.put(x, y, -1.0);
                }
                this.updateProgression(total);
            }
        }
        for (y = 0; y <= this.height - 1; ++y) {
            for (x = 0; x <= this.width - 1; ++x) {
                v = output.get(x, y);
                if (v < 0.0) continue;
                for (k = 0; k < this.chamfer.length; ++k) {
                    int dx = this.chamfer[k][0];
                    dy = this.chamfer[k][1];
                    dt = this.chamfer[k][2];
                    this.testAndSet(output, x + dx, y + dy, v + (double)dt);
                    if (dy != 0) {
                        this.testAndSet(output, x - dx, y + dy, v + (double)dt);
                    }
                    if (dx == dy) continue;
                    this.testAndSet(output, x + dy, y + dx, v + (double)dt);
                    if (dy == 0) continue;
                    this.testAndSet(output, x - dy, y + dx, v + (double)dt);
                }
                this.updateProgression(total);
            }
        }
        for (y = this.height - 1; y >= 0; --y) {
            for (x = this.width - 1; x >= 0; --x) {
                v = output.get(x, y);
                if (v < 0.0) continue;
                for (k = 0; k < this.chamfer.length; ++k) {
                    int dx = this.chamfer[k][0];
                    dy = this.chamfer[k][1];
                    dt = this.chamfer[k][2];
                    this.testAndSet(output, x - dx, y - dy, v + (double)dt);
                    if (dy != 0) {
                        this.testAndSet(output, x + dx, y - dy, v + (double)dt);
                    }
                    if (dx == dy) continue;
                    this.testAndSet(output, x - dy, y - dx, v + (double)dt);
                    if (dy == 0) continue;
                    this.testAndSet(output, x + dy, y - dx, v + (double)dt);
                }
                this.updateProgression(total);
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                output.put(x, y, output.get(x, y) / (double)this.normalizer * input.cellsize());
                this.updateProgression(total);
            }
        }
        return output;
    }

    private double[][] compute(int[][] input) {
        int dt;
        int dy;
        int dx;
        int k;
        double v;
        int x;
        int y;
        this.width = input[0].length;
        this.height = input.length;
        double[][] output = new double[this.width][this.height];
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                output[x][y] = input[x][y] == 1 ? 0.0 : -1.0;
            }
        }
        for (y = 0; y <= this.height - 1; ++y) {
            for (x = 0; x <= this.width - 1; ++x) {
                v = output[x][y];
                if (v < 0.0) continue;
                for (k = 0; k < this.chamfer.length; ++k) {
                    dx = this.chamfer[k][0];
                    dy = this.chamfer[k][1];
                    dt = this.chamfer[k][2];
                    this.testAndSet(output, x + dx, y + dy, v + (double)dt);
                    if (dy != 0) {
                        this.testAndSet(output, x - dx, y + dy, v + (double)dt);
                    }
                    if (dx == dy) continue;
                    this.testAndSet(output, x + dy, y + dx, v + (double)dt);
                    if (dy == 0) continue;
                    this.testAndSet(output, x - dy, y + dx, v + (double)dt);
                }
            }
        }
        for (y = this.height - 1; y >= 0; --y) {
            for (x = this.width - 1; x >= 0; --x) {
                v = output[x][y];
                if (v < 0.0) continue;
                for (k = 0; k < this.chamfer.length; ++k) {
                    dx = this.chamfer[k][0];
                    dy = this.chamfer[k][1];
                    dt = this.chamfer[k][2];
                    this.testAndSet(output, x - dx, y - dy, v + (double)dt);
                    if (dy != 0) {
                        this.testAndSet(output, x + dx, y - dy, v + (double)dt);
                    }
                    if (dx == dy) continue;
                    this.testAndSet(output, x - dy, y - dx, v + (double)dt);
                    if (dy == 0) continue;
                    this.testAndSet(output, x + dy, y - dx, v + (double)dt);
                }
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                output[x][y] = output[x][y] / (double)this.normalizer;
            }
        }
        return output;
    }
}

