/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.QuantitativeCountingInterface;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;

public class Stats
implements QuantitativeCountingInterface {
    private double sum;
    private double squaresum;
    private double variance;
    private double average;
    private double stddeviation;
    private double min;
    private double max;
    private double stderror;
    private double varK;
    private int nb;
    private int nbPos;
    private int nbNeg;
    private List<Double> values = new ArrayList<Double>();
    private static DecimalFormat format;

    public Stats() {
        this.reset();
    }

    private static double format(double v) {
        if (Double.isNaN(v)) {
            return -1.0;
        }
        int f = new Double(Math.floor(v)).intValue();
        if (v == (double)f) {
            return f;
        }
        return Double.parseDouble(format.format(v));
    }

    public void reset() {
        this.values.clear();
        this.sum = 0.0;
        this.squaresum = 0.0;
        this.variance = 0.0;
        this.average = 0.0;
        this.stddeviation = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        this.stderror = 0.0;
        this.nb = 0;
        this.nbPos = 0;
        this.nbNeg = 0;
        this.varK = 0.0;
    }

    public void add(double v) {
        this.values.add(v);
    }

    public void calculate() {
        boolean hasMin = false;
        boolean hasMax = false;
        for (double v : this.values) {
            if (hasMin) {
                this.min = Math.min(this.min, v);
            } else {
                this.min = v;
                hasMin = true;
            }
            if (hasMax) {
                this.max = Math.max(this.max, v);
            } else {
                this.max = v;
                hasMax = true;
            }
            if (v > 0.0) {
                ++this.nbPos;
            } else if (v < 0.0) {
                ++this.nbNeg;
            }
            this.sum += v;
            this.squaresum += v * v;
        }
        this.nb = this.values.size();
        if (this.nb == 0) {
            this.min = Raster.getNoDataValue();
            this.max = Raster.getNoDataValue();
            this.nbPos = Raster.getNoDataValue();
            this.nbNeg = Raster.getNoDataValue();
            this.sum = Raster.getNoDataValue();
            this.squaresum = Raster.getNoDataValue();
            this.average = Raster.getNoDataValue();
            this.variance = Raster.getNoDataValue();
            this.stddeviation = Raster.getNoDataValue();
            this.varK = Raster.getNoDataValue();
            this.stderror = Raster.getNoDataValue();
        } else {
            this.average = this.getSum() / (double)this.size();
            this.variance = Math.abs(this.getSquareSum() / (double)this.size() - this.getAverage() * this.getAverage());
            this.stddeviation = Math.sqrt(this.getVariance());
            this.varK = this.getStandardDeviation() / this.getAverage();
            this.stderror = this.getStandardDeviation() / Math.sqrt(this.values.size());
        }
    }

    @Override
    public double getVariance() {
        return Stats.format(this.variance);
    }

    @Override
    public double getAverage() {
        return Stats.format(this.average);
    }

    @Override
    public double getSum() {
        return Stats.format(this.sum);
    }

    @Override
    public double getSquareSum() {
        return Stats.format(this.squaresum);
    }

    @Override
    public double getStandardDeviation() {
        return Stats.format(this.stddeviation);
    }

    @Override
    public double getMaximum() {
        return Stats.format(this.max);
    }

    @Override
    public double getMinimum() {
        return Stats.format(this.min);
    }

    @Override
    public double getStandardError() {
        return Stats.format(this.stderror);
    }

    @Override
    public double getVariationCoefficient() {
        return Stats.format(this.varK);
    }

    @Override
    public int countPositives() {
        return this.nbPos;
    }

    @Override
    public int countNegatives() {
        return this.nbNeg;
    }

    @Override
    public int size() {
        return this.nb;
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format = new DecimalFormat("0.00000", symbols);
    }
}

