/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MedianVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.util.Converters;
import org.geotools.util.UnsupportedImplementationException;
import org.opengis.filter.expression.Expression;

public enum Aggregate {
    AVERAGE{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new AverageVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            throw new UnsupportedImplementationException("Wrapping raw result of average visitor not supported.");
        }
    }
    ,
    COUNT{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new CountVisitor();
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            CountVisitor visitor = new CountVisitor();
            visitor.setValue(Converters.convert(value, Integer.class));
            return visitor.getResult();
        }
    }
    ,
    MAX{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new MaxVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            MaxVisitor visitor = new MaxVisitor(aggregateAttribute);
            visitor.setValue(value);
            return visitor.getResult();
        }
    }
    ,
    MEDIAN{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new MedianVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            throw new UnsupportedImplementationException("Wrapping raw result of mean visitor not supported.");
        }
    }
    ,
    MIN{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new MinVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            MinVisitor visitor = new MinVisitor(aggregateAttribute);
            visitor.setValue(value);
            return visitor.getResult();
        }
    }
    ,
    STD_DEV{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new StandardDeviationVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            throw new UnsupportedImplementationException("Wrapping raw result of standard deviation visitor not supported.");
        }
    }
    ,
    SUM{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new SumVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            SumVisitor visitor = new SumVisitor(aggregateAttribute);
            visitor.setValue(value);
            return visitor.getResult();
        }
    };


    public abstract FeatureCalc create(Expression var1);

    public abstract CalcResult wrap(Expression var1, Object var2);

    public static Aggregate permissiveValueOf(String visitorName) {
        switch (visitorName.toLowerCase()) {
            case "average": {
                return AVERAGE;
            }
            case "count": {
                return COUNT;
            }
            case "max": {
                return MAX;
            }
            case "median": {
                return MEDIAN;
            }
            case "min": {
                return MIN;
            }
            case "std_dev": {
                return STD_DEV;
            }
            case "stddev": {
                return STD_DEV;
            }
            case "sum": {
                return SUM;
            }
        }
        throw new IllegalArgumentException(String.format("Visitor with name '%s' is not a valid group by visitor.", visitorName));
    }
}

