/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul.operation;

import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.simul.operation.Allocation;
import fr.inra.sad.bagap.apiland.simul.operation.OpComposition;
import fr.inra.sad.bagap.apiland.simul.operation.OpTypeAllocation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class OpAllocation
extends OpComposition {
    private static final long serialVersionUID = 1L;
    private Set<Allocation<?>> allocations;

    public OpAllocation(OpTypeAllocation type) {
        super(type);
        this.allocations = type.getAllocations();
    }

    @Override
    public OpAllocation clone() {
        OpAllocation clone = (OpAllocation)super.clone();
        clone.allocations = this.allocations;
        return clone;
    }

    @Override
    public boolean make(Instant t, DynamicElement ... e) {
        double total = e[0].getArea(t);
        Iterator ite = ((DynamicLayer)e[0]).activeDeepIterator(t);
        ArrayList features = new ArrayList();
        while (ite.hasNext()) {
            features.add(ite.next());
        }
        Allocation<?> last = null;
        Iterator<Allocation<?>> iterator = this.allocations.iterator();
        while (iterator.hasNext()) {
            DynamicElement f;
            Allocation<?> a;
            last = a = iterator.next();
            for (double surface = total * (a.getRate() / 100.0); surface > 0.0 && features.size() != 0; surface -= f.getArea(t)) {
                int rd = new Double((double)features.size() * Math.random()).intValue();
                f = (DynamicElement)features.remove(rd);
                f.getAttribute(this.getAttribute()).setValue(t, (Serializable)a.getObject());
            }
        }
        while (features.size() != 0) {
            ((DynamicElement)features.remove(0)).getAttribute(this.getAttribute()).setValue(t, (Serializable)last.getObject());
        }
        return true;
    }

    @Override
    public void delete() {
        super.delete();
        for (Allocation<?> a : this.allocations) {
            a.delete();
        }
        this.allocations.clear();
        this.allocations = null;
    }
}

