/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public abstract class SimulatorProcess
extends SwingWorker<Boolean, String> {
    private JTextArea[] textAreas;

    public SimulatorProcess(final JProgressBar progressBar, JTextArea ... textAreas) {
        this.textAreas = textAreas;
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    progressBar.setValue((Integer)evt.getNewValue());
                }
            }
        });
    }

    @Override
    protected void process(List<String> strings) {
        for (String s : strings) {
            for (JTextArea ta : this.textAreas) {
                ta.append(s + '\n');
            }
        }
    }

    @Override
    protected void done() {
        try {
            if (this.isCancelled()) {
                this.publish("CANCEL : cancelled operation");
                return;
            }
            if (!((Boolean)this.get()).booleanValue()) {
                this.publish("ERROR : simulator error");
                return;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void display(String text) {
        this.publish(text);
    }

    public void up(int progress) {
        this.setProgress(progress);
    }
}

