/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul;

import fr.inra.sad.bagap.apiland.core.element.map.DefaultDynamicMap;
import fr.inra.sad.bagap.apiland.core.element.map.DynamicMap;
import fr.inra.sad.bagap.apiland.simul.OutputAnalysis;
import fr.inra.sad.bagap.apiland.simul.OutputManager;
import fr.inra.sad.bagap.apiland.simul.Scenario;
import fr.inra.sad.bagap.apiland.simul.SimulationFactory;
import fr.inra.sad.bagap.apiland.simul.SimulationManager;
import fr.inra.sad.bagap.apiland.simul.SimulatorProcess;
import fr.inra.sad.bagap.apiland.simul.SimulatorState;
import fr.inra.sad.bagap.apiland.simul.model.APILandModel;
import fr.inra.sad.bagap.apiland.simul.model.ModelManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class Simulator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SimulationManager manager;
    private Scenario[] scenarios;
    private SimulationFactory factory;
    private int number;
    private APILandModel model;
    private SimulatorState state;
    private boolean batchMode = false;
    private transient int up = 0;
    private OutputManager outputs;

    public Simulator() {
        this(new SimulationManager(1), new SimulationFactory());
    }

    public Simulator(int s) {
        this(new SimulationManager(s), new SimulationFactory());
    }

    public Simulator(SimulationManager manager) {
        this(manager, new SimulationFactory());
    }

    public Simulator(SimulationFactory factory, int s) {
        this(new SimulationManager(s), factory);
    }

    public Simulator(SimulationManager manager, SimulationFactory factory) {
        this.manager = manager;
        this.factory = factory;
        this.state = SimulatorState.IDLE;
        this.outputs = new OutputManager();
    }

    public String toString() {
        return "simulator_" + this.number;
    }

    public String folder() {
        return this.manager().expFolder() + "/outputs/";
    }

    public SimulationManager manager() {
        return this.manager;
    }

    public SimulationFactory factory() {
        return this.factory;
    }

    public int number() {
        return this.number;
    }

    private void add(Scenario scenario) {
        this.scenarios[scenario.number() - 1] = scenario;
    }

    public void init(int number) {
        this.manager.display("simulator " + number + " initialization");
        this.number = number;
        new File(this.manager().expFolder() + "/outputs/").mkdirs();
        this.manager.display("scenarios creation");
        this.scenarios = new Scenario[this.manager.scenarios()];
        for (int i = 1; i <= this.scenarios.length; ++i) {
            this.add(this.factory().createScenario(this, i));
        }
        this.up(25);
        this.manager.display("APILand model creation");
        this.model = new APILandModel("model", this.manager.start(), this.manager.delay(), this, new DefaultDynamicMap());
        this.up(25);
        this.initModel();
        this.outputs.init(this);
        this.up(25);
        if (this.manager.scenarios() > 1) {
            // empty if block
        }
        this.state = SimulatorState.INIT;
        this.up(25);
    }

    public void init(String path) {
        this.batchMode = true;
        this.manager.init(path + "/experience.properties");
        this.init(Integer.parseInt(new File(path).getName().replace("exp", "")));
    }

    public void run() {
        this.manager.display("run simulator");
        if (this.state == SimulatorState.INIT) {
            this.state = SimulatorState.RUN;
            for (int i = 0; i < this.manager().scenarios(); ++i) {
                Scenario s = this.scenarios[i];
                if (this.batchMode) {
                    s.init(this.manager().expFolder() + "/scenario_" + s.number() + ".properties");
                } else {
                    s.init();
                }
                s.run();
                s.close();
            }
            this.outputs.calculate(this);
            this.state = SimulatorState.FINISHED;
        }
    }

    public void runAndDelete() {
        this.manager.display("run simulator");
        if (this.state == SimulatorState.INIT) {
            this.state = SimulatorState.RUN;
            for (int i = 0; i < this.manager().scenarios(); ++i) {
                Scenario s = this.scenarios[i];
                if (this.batchMode) {
                    s.init(this.manager().expFolder() + "/scenario_" + s.number() + ".properties");
                } else {
                    s.init();
                }
                s.run();
                s.close();
                s.delete();
            }
            this.outputs.calculate(this);
            this.state = SimulatorState.FINISHED;
        }
    }

    public void close() {
        this.manager.display("close simulator " + this.number);
        this.outputs.close(this);
    }

    protected void initModel() {
    }

    private void saveModel() {
        try {
            ModelManager.save(this.model, this.manager().expFolder() + "/outputs/simulator.model");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Scenario[] scenarios() {
        return this.scenarios;
    }

    public void deleteScenario(Scenario s) {
        for (int i = 0; i < this.scenarios.length; ++i) {
            if (this.scenarios[i] == null || !this.scenarios[i].equals(s)) continue;
            this.scenarios[i] = null;
            return;
        }
    }

    public DynamicMap map() {
        return this.model.map();
    }

    public APILandModel model() {
        return this.model;
    }

    public SimulatorState getState() {
        return this.state;
    }

    public void setState(SimulatorState state) {
        this.state = state;
    }

    public void setSimulatorProcess(SimulatorProcess sp) {
        this.up = 0;
        this.manager.up(this.up);
        this.manager.setSimulatorProcess(sp);
    }

    public void up(int progress) {
        this.up += progress;
        this.manager().up(this.up);
    }

    public OutputManager outputs() {
        return this.outputs;
    }

    public void addOutput(OutputAnalysis out) {
        this.outputs.add(out);
    }
}

