/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul;

import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Time;
import fr.inra.sad.bagap.apiland.core.time.delay.DayDelay;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import fr.inra.sad.bagap.apiland.core.time.delay.MonthDelay;
import fr.inra.sad.bagap.apiland.core.time.delay.YearDelay;
import fr.inra.sad.bagap.apiland.simul.SimulatorProcess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SimulationManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Instant start;
    private Instant end;
    private Delay delay;
    private int simulations = 1;
    private int scenarios = 1;
    private int number;
    private int success = 0;
    private String path;
    protected String expFolder;
    private transient SimulatorProcess sp;
    private transient boolean cancelled = false;
    private transient boolean console = true;

    public SimulationManager(int s) {
        this.number = s;
    }

    public void init(String propertiesFile) {
        try {
            Properties properties = new Properties();
            FileInputStream in = new FileInputStream(propertiesFile);
            properties.load(in);
            in.close();
            this.expFolder = new File(propertiesFile).getParent();
            if (properties.containsKey("start")) {
                this.start = Time.get(properties.getProperty("start"));
            }
            if (properties.containsKey("end")) {
                this.end = Time.get(properties.getProperty("end"));
            }
            if (properties.containsKey("delayType")) {
                String delayType = properties.getProperty("delayType");
                if (delayType.equalsIgnoreCase("day")) {
                    this.delay = new DayDelay(new Integer(properties.getProperty("delay")).intValue());
                } else if (delayType.equalsIgnoreCase("month")) {
                    this.delay = new MonthDelay(new Integer(properties.getProperty("delay")));
                } else if (delayType.equalsIgnoreCase("year")) {
                    this.delay = new YearDelay(new Integer(properties.getProperty("delay")));
                }
            }
            if (properties.containsKey("simulations")) {
                this.simulations = new Integer(properties.getProperty("simulations"));
            }
            if (properties.containsKey("scenarios")) {
                this.scenarios = new Integer(properties.getProperty("scenarios"));
            }
            if (properties.containsKey("path")) {
                this.path = properties.getProperty("path");
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public int number() {
        return this.number;
    }

    public Instant start() {
        return this.start;
    }

    public Instant end() {
        return this.end;
    }

    public Delay delay() {
        return this.delay;
    }

    public int simulations() {
        return this.simulations;
    }

    public int scenarios() {
        return this.scenarios;
    }

    public String path() {
        return this.path;
    }

    public String expFolder() {
        return this.expFolder;
    }

    public void setSimulations(int s) {
        this.simulations = s;
    }

    public void setScenarios(int s) {
        this.scenarios = s;
    }

    public void setSuccess(int s) {
        this.success = s;
    }

    public int success() {
        return this.success;
    }

    public void setSettings(String key, String value) {
        if (key.equalsIgnoreCase("start")) {
            this.start = Time.get(value);
            return;
        }
        if (key.equalsIgnoreCase("end")) {
            this.end = Time.get(value);
            return;
        }
        if (key.equalsIgnoreCase("delay")) {
            this.delay = new DayDelay(new Integer(value).intValue());
            return;
        }
        if (key.equalsIgnoreCase("simulations")) {
            this.simulations = new Integer(value);
            return;
        }
        if (key.equalsIgnoreCase("scenarios")) {
            this.scenarios = new Integer(value);
            return;
        }
        if (key.equalsIgnoreCase("path")) {
            this.path = value;
            return;
        }
        if (key.equalsIgnoreCase("expFolder")) {
            this.expFolder = value;
            return;
        }
    }

    public void setSimulatorProcess(SimulatorProcess sp) {
        this.sp = sp;
    }

    public void setConsole(boolean console) {
        this.console = console;
    }

    public void display(String text) {
        if (this.console) {
            System.out.println(text);
        }
        if (this.sp != null) {
            this.sp.display(text);
        }
    }

    public void up(int progress) {
        if (this.sp != null) {
            this.sp.up(progress);
        }
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public boolean isCancelled() {
        if (this.sp != null) {
            return this.sp.isCancelled();
        }
        return this.cancelled;
    }

    public List<Integer> years() {
        ArrayList<Integer> years = new ArrayList<Integer>();
        int y = Time.getYear(this.start);
        while (y <= Time.getYear(this.end)) {
            years.add(y++);
        }
        return years;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setStart(Instant t) {
        this.start = t;
    }

    public void setEnd(Instant t) {
        this.end = t;
    }

    public void setTime(Instant start, Instant end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public void setDelay(Delay d) {
        this.delay = d;
    }
}

