/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.util;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.core.util.TransitionMatrix;
import fr.inra.sad.bagap.apiland.core.util.TransitionMatrixBuilder;
import java.io.IOException;
import java.io.Serializable;

public class TransitionMatrixFactory {
    public static <O extends Serializable> TransitionMatrix<O> create(String f, Class<?> c) {
        TransitionMatrix tMat = null;
        try {
            CsvReader cr = new CsvReader(f);
            cr.setDelimiter(';');
            cr.readHeaders();
            TransitionMatrixBuilder<Serializable> builder = new TransitionMatrixBuilder<Serializable>();
            while (cr.readRecord()) {
                for (String in : cr.getHeaders()) {
                    if (in.equalsIgnoreCase("out-in")) continue;
                    builder.setTransitionRate(TransitionMatrixFactory.getFromString(in, c), TransitionMatrixFactory.getFromString(cr.get("out-in"), c), Double.parseDouble(cr.get(in)));
                }
            }
            tMat = builder.build();
            cr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (CsvReader.FinalizedException e) {
            e.printStackTrace();
        }
        catch (CsvReader.CatastrophicException e) {
            e.printStackTrace();
        }
        return tMat;
    }

    public static Serializable getFromString(String s, Class<?> c) {
        if (c.equals(Integer.class)) {
            return new Integer(s);
        }
        throw new IllegalArgumentException();
    }
}

