/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.util;

import fr.inra.sad.bagap.apiland.core.util.Fourchette;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Manager<E extends Comparable<E>> {
    private Map<E, Integer> elements;
    private int total;

    public Manager() {
        this.reset();
    }

    public void reset() {
        this.elements = new TreeMap<E, Integer>();
        this.total = 0;
    }

    private boolean contains(E e) {
        for (Comparable i : this.elements.keySet()) {
            if (!i.equals(e)) continue;
            return true;
        }
        return false;
    }

    private void set(E e) {
        this.elements.put(e, 0);
    }

    private void put(E e) {
        this.elements.put(e, this.elements.get(e) + 1);
        ++this.total;
    }

    public void add(E e) {
        if (!this.contains(e)) {
            this.set(e);
        }
        this.put(e);
    }

    public void display() {
        for (Map.Entry<E, Integer> e : this.elements.entrySet()) {
            System.out.println(e.getKey() + " --> " + e.getValue() + ", soit " + new Double(e.getValue().intValue()) * 100.0 / (double)this.total + "%");
        }
    }

    public Map<E, Double> gets() {
        HashMap<E, Double> results = new HashMap<E, Double>();
        for (Map.Entry<E, Integer> e : this.elements.entrySet()) {
            results.put(e.getKey(), new Double(e.getValue().intValue()) * 100.0 / (double)this.total);
        }
        return results;
    }

    public double note(Map<E, Fourchette> ref) {
        double note = 0.0;
        for (Map.Entry<E, Double> e : this.gets().entrySet()) {
            note += ref.get(e.getKey()).distance(e.getValue());
        }
        return note;
    }
}

