/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class FunctionalDistanceSinglePixelIterator
implements Iterator<Pixel> {
    private Pixel pixel;
    private double distance;
    private Set<Pixel> around;
    private Iterator<Pixel> ite;
    private Matrix matrix;
    private Matrix frictionMat;
    private Friction frictionMap;
    private boolean map;

    public FunctionalDistanceSinglePixelIterator(Pixel pixel, double distance, Matrix matrix, Matrix friction) {
        this.pixel = pixel;
        this.distance = distance;
        this.matrix = matrix;
        this.frictionMat = friction;
        this.map = false;
        this.init();
    }

    public FunctionalDistanceSinglePixelIterator(Pixel pixel, double distance, Matrix matrix, Friction friction) {
        this.pixel = pixel;
        this.distance = distance;
        this.matrix = matrix;
        this.frictionMap = friction;
        this.map = true;
        this.init();
    }

    private void init() {
        this.around = new TreeSet<Pixel>();
        HashMap<Pixel, Double> rcm = new HashMap<Pixel, Double>();
        rcm.put(this.pixel, 0.0);
        TreeSet<Pixel> waits = new TreeSet<Pixel>();
        waits.add(this.pixel);
        while (!waits.isEmpty()) {
            this.diffuse(rcm, waits);
        }
        this.ite = this.around.iterator();
    }

    private void diffuse(Map<Pixel, Double> rcm, TreeSet<Pixel> waits) {
        Pixel p = waits.pollFirst();
        double f = this.map ? this.frictionMap.get(this.matrix.get(p)) : this.frictionMat.get(p);
        if (f != (double)Raster.getNoDataValue()) {
            double v = rcm.get(p);
            this.diffuseRook(p, new Pixel(p.x(), p.y() - 1), v, f, rcm, waits);
            this.diffuseRook(p, new Pixel(p.x() + 1, p.y()), v, f, rcm, waits);
            this.diffuseRook(p, new Pixel(p.x(), p.y() + 1), v, f, rcm, waits);
            this.diffuseRook(p, new Pixel(p.x() - 1, p.y()), v, f, rcm, waits);
            this.diffuseQueen(p, new Pixel(p.x() + 1, p.y() - 1), v, f, rcm, waits);
            this.diffuseQueen(p, new Pixel(p.x() + 1, p.y() + 1), v, f, rcm, waits);
            this.diffuseQueen(p, new Pixel(p.x() - 1, p.y() + 1), v, f, rcm, waits);
            this.diffuseQueen(p, new Pixel(p.x() - 1, p.y() - 1), v, f, rcm, waits);
        }
    }

    private void diffuseRook(Pixel pc, Pixel op, double v, double f, Map<Pixel, Double> rcm, TreeSet<Pixel> waits) {
        double ov;
        double of;
        if (this.matrix.contains(op) && (of = this.map ? this.frictionMap.get(this.matrix.get(op)) : this.frictionMat.get(op)) != (double)Raster.getNoDataValue() && (ov = v + (this.matrix.cellsize() / 2.0 * f + this.matrix.cellsize() / 2.0 * of)) <= this.distance) {
            this.around.add(op);
            rcm.put(op, ov);
            waits.add(op);
        }
    }

    private void diffuseQueen(Pixel pc, Pixel op, double v, double f, Map<Pixel, Double> rcm, TreeSet<Pixel> waits) {
        double ov;
        double of;
        if (this.matrix.contains(op) && (of = this.map ? this.frictionMap.get(this.matrix.get(op)) : this.frictionMat.get(op)) != (double)Raster.getNoDataValue() && (ov = v + (Math.sqrt(2.0) * this.matrix.cellsize() / 2.0 * f + Math.sqrt(2.0) * this.matrix.cellsize() / 2.0 * of)) <= this.distance) {
            this.around.add(op);
            rcm.put(op, ov);
            waits.add(op);
        }
    }

    @Override
    public boolean hasNext() {
        return this.ite.hasNext();
    }

    @Override
    public Pixel next() {
        return this.ite.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

