/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.element.neighbourhood;

import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.decorator.AbstractDynamicElementDecorator;
import fr.inra.sad.bagap.apiland.core.element.neighbourhood.NeighbourElement;
import fr.inra.sad.bagap.apiland.core.element.neighbourhood.Neighbourhood;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementType;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.HashSet;
import java.util.Set;

public abstract class NeighbourFeature<E extends DynamicElement>
extends AbstractDynamicElementDecorator<E>
implements NeighbourElement {
    private static final long serialVersionUID = 1L;
    private Set<Neighbourhood> neighbourhoods = new HashSet<Neighbourhood>();

    public NeighbourFeature(E element, DynamicElementType type) {
        super(element, type);
    }

    @Override
    public NeighbourFeature<E> clone() {
        NeighbourFeature clone = (NeighbourFeature)super.clone();
        clone.neighbourhoods = new HashSet<Neighbourhood>();
        for (Neighbourhood n : this.neighbourhoods) {
            clone.addNeighbourhood(n.clone());
        }
        return clone;
    }

    @Override
    public Set<? extends Neighbourhood> getNeighbourhoods() {
        return this.neighbourhoods;
    }

    @Override
    public void addNeighbourhood(Neighbourhood neighbourhood) {
        neighbourhood.setNeighbour(this);
        this.neighbourhoods.add(neighbourhood);
    }

    @Override
    public void displayNeighbourhood(Instant t) {
        for (Neighbourhood n : this.getNeighbourhoods()) {
            if (!n.isActive(t)) continue;
            System.out.println(n.getNeighbour(this) + " : " + n.length(t));
        }
    }

    @Override
    public Set<DynamicElement> getNeighbours(Instant t) {
        HashSet<DynamicElement> neighbours = new HashSet<DynamicElement>();
        for (Neighbourhood v : this.getNeighbourhoods()) {
            if (!v.isActive(t)) continue;
            neighbours.add(v.getNeighbour(this));
        }
        return neighbours;
    }

    @Override
    public Neighbourhood getNeighbourhood(DynamicElement element) {
        for (Neighbourhood n : this.getNeighbourhoods()) {
            if (!n.getNeighbour(this).equals(element)) continue;
            return n;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getNeighbourhoodCount() {
        return this.neighbourhoods.size();
    }

    @Override
    public double perimeter(Instant t) {
        return this.getLength(t);
    }

    @Override
    public double getNeighbourhoodPerimeter(Instant t) {
        double perimeter = 0.0;
        for (Neighbourhood v : this.getNeighbourhoods()) {
            perimeter += v.getLength(t);
        }
        return perimeter;
    }

    @Override
    public boolean isClosed(Instant t) {
        return this.perimeter(t) - this.getNeighbourhoodPerimeter(t) == 0.0;
    }

    @Override
    public double getUnclosedPerimeter(Instant t) {
        return this.perimeter(t) - this.getNeighbourhoodPerimeter(t);
    }
}

