/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.element.manager;

import fr.inra.sad.bagap.apiland.core.composition.Attribute;
import fr.inra.sad.bagap.apiland.core.composition.AttributeType;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicElementFactory;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementType;
import fr.inra.sad.bagap.apiland.core.space.Geometry;
import fr.inra.sad.bagap.apiland.core.structure.MultipleStructure;
import fr.inra.sad.bagap.apiland.core.structure.NullStructure;
import fr.inra.sad.bagap.apiland.core.structure.Representation;
import fr.inra.sad.bagap.apiland.core.structure.RepresentationType;
import fr.inra.sad.bagap.apiland.core.structure.SimpleStructure;
import fr.inra.sad.bagap.apiland.core.structure.Structure;
import fr.inra.sad.bagap.apiland.core.time.Time;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class DynamicElementBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DynamicElementType type;
    private String id;
    private Time time;
    private Composition composition;
    private Structure structure;

    public DynamicElementBuilder(DynamicElementType type) {
        this.type = type;
        this.reset();
    }

    protected Time getTime() {
        return this.time;
    }

    protected DynamicElementType getType() {
        return this.type;
    }

    protected Composition getComposition() {
        return this.composition;
    }

    protected Structure getStructure() {
        return this.structure;
    }

    protected String getId() {
        return this.id;
    }

    public void display() {
        for (Attribute<?> a : this.composition) {
            a.display();
        }
        for (Representation r : this.structure) {
            r.display();
        }
    }

    protected void reset() {
        this.id = null;
        this.time = null;
        this.composition = new Composition();
        for (AttributeType attributeType : this.type.getAttributeTypes()) {
            this.composition.addAttribute(DynamicElementFactory.createAttribute(attributeType));
        }
        if (this.type.getRepresentationTypes().size() == 1) {
            this.structure = new SimpleStructure();
            this.structure.addRepresentation(DynamicElementFactory.createRepresentation(this.type.getRepresentationTypes().get(0)));
        } else if (this.type.getRepresentationTypes().size() > 1) {
            this.structure = new MultipleStructure();
            for (RepresentationType representationType : this.type.getRepresentationTypes()) {
                this.structure.addRepresentation(DynamicElementFactory.createRepresentation(representationType));
            }
        } else {
            this.structure = new NullStructure();
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    public void setComposition(Composition composition) {
        this.composition = composition;
    }

    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    public void setAttribute(String name, Time t, Serializable o) {
        if (!(o == null || o.getClass().equals(String.class) && ((String)((Object)o)).equals(""))) {
            if (this.type.getAttributeType(name).getBinding().equals(o.getClass())) {
                this.composition.getAttribute(name).setValue(t, o);
            } else {
                try {
                    Serializable ob = (Serializable)this.type.getAttributeType(name).getBinding().getConstructor(o.getClass()).newInstance(o);
                    this.composition.getAttribute(name).setValue(t, ob);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setAttribute(Attribute attribute) {
        this.composition.addAttribute(attribute);
    }

    public void setRepresentation(String name, Time t, Geometry g) {
        this.structure.getRepresentation(name).setGeometry(t, g);
    }

    public void setRepresentation(String name, Time t) {
        this.structure.getRepresentation(name).setTime(t);
    }

    public void setRepresentation(Representation representation) {
        this.structure.addRepresentation(representation);
    }

    private boolean isValid() {
        if (this.structure != null && this.composition != null) {
            return true;
        }
        System.err.println("element parameter must not be empty !!!");
        return false;
    }

    public <E extends DynamicElement> E build() {
        if (this.isValid()) {
            Object element = DynamicElementFactory.createDynamicElement(this.getType().getBinding(), this.getType(), this.getId(), this.getTime(), this.getComposition(), this.getStructure());
            this.reset();
            return element;
        }
        throw new IllegalArgumentException("parameters are not initialized !!!");
    }
}

