/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul.output;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.GlobalCoverLocationModel;
import fr.inra.sad.bagap.apiland.simul.OutputAnalysis;
import fr.inra.sad.bagap.apiland.simul.Scenario;
import fr.inra.sad.bagap.apiland.simul.Simulation;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FarmMemoryOutput
extends OutputAnalysis {
    private Map<String, CsvWriter> cws;
    private boolean isInit;
    private String path;

    public FarmMemoryOutput() {
    }

    public FarmMemoryOutput(String path) {
        if (path != null) {
            this.path = path;
        }
    }

    @Override
    public void init(Scenario scenario) {
        if (this.path == null) {
            this.path = scenario.folder() + "memory/";
        }
        this.cws = new HashMap<String, CsvWriter>();
        new File(this.path).mkdir();
        this.isInit = false;
    }

    public void firstInit(Simulation simulation) {
        if (!this.isInit) {
            try {
                for (CoverLocationModel model : (GlobalCoverLocationModel)simulation.model().get("agriculture")) {
                    new File(this.path + model.getCoverAllocator().getCode() + "/" + model.getCoverAllocator().getFarmingSystem() + "/memory/").mkdirs();
                    CsvWriter cw = new CsvWriter(this.path + model.getCoverAllocator().getCode() + "/" + model.getCoverAllocator().getFarmingSystem() + "/" + model.getCoverAllocator().getCode() + "_memory.csv");
                    cw.setDelimiter(';');
                    cw.write("memory");
                    cw.write("file");
                    cw.endRecord();
                    this.cws.put(model.getCoverAllocator().getCode(), cw);
                }
            }
            catch (CsvWriter.FinalizedException | IOException e) {
                e.printStackTrace();
            }
            this.isInit = true;
        }
    }

    @Override
    public void close(Scenario scenario) {
        for (CsvWriter cw : this.cws.values()) {
            cw.close();
        }
        this.cws = null;
    }

    @Override
    public void close(Simulation simulation) {
        if (!simulation.isCancelled()) {
            this.firstInit(simulation);
            try {
                for (CoverLocationModel model : (GlobalCoverLocationModel)simulation.model().get("agriculture")) {
                    CsvWriter cw = this.cws.get(model.getCoverAllocator().getCode());
                    cw.write(simulation.number() + "");
                    cw.write("memory/" + model.getCoverAllocator().getCode() + "_memory_" + simulation.number() + ".csv");
                    cw.endRecord();
                    cw = new CsvWriter(this.path + model.getCoverAllocator().getCode() + "/" + model.getCoverAllocator().getFarmingSystem() + "/memory/" + model.getCoverAllocator().getCode() + "_memory_" + simulation.number() + ".csv");
                    cw.setDelimiter(';');
                    cw.write("parcel");
                    cw.write("seq_cover");
                    cw.endRecord();
                    for (Parcel p : model.getCoverAllocator().parcels()) {
                        cw.write(p.getId());
                        cw.write((String)p.getAttribute("strict_seq").getValue(simulation.manager().end()));
                        cw.endRecord();
                    }
                    cw.close();
                }
            }
            catch (CsvWriter.FinalizedException | IOException e) {
                e.printStackTrace();
            }
        }
    }
}

