/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul.graph;

import fr.inra.sad.bagap.apiland.capfarm.simul.graph.Arc;
import fr.inra.sad.bagap.apiland.capfarm.simul.graph.Cycle;
import fr.inra.sad.bagap.apiland.capfarm.simul.graph.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Graph<E> {
    private Set<Node<E>> nodes = new HashSet<Node<E>>();
    private List<Arc<E>> arcs = new ArrayList<Arc<E>>();
    private Set<Cycle<E>> cycles = new HashSet<Cycle<E>>();

    public Node<E> addNode(E e) {
        if (!this.hasNode(e)) {
            this.nodes.add(new Node<E>(e));
        }
        return this.getNode(e);
    }

    private Node<E> getNode(E e) {
        for (Node<E> n : this.nodes) {
            if (!n.getElement().equals(e)) continue;
            return n;
        }
        throw new IllegalArgumentException(e + "");
    }

    private boolean hasNode(E e) {
        for (Node<E> n : this.nodes) {
            if (!n.getElement().equals(e)) continue;
            return true;
        }
        return false;
    }

    public Arc<E> addArc(E e1, E e2) {
        Node<E> n2;
        Node<E> n1 = this.addNode(e1);
        if (!this.hasArc(n1, n2 = this.addNode(e2))) {
            this.arcs.add(new Arc<E>(n1, n2));
        }
        return this.getArc(n1, n2);
    }

    private Arc<E> getArc(Node<E> n1, Node<E> n2) {
        for (Arc<E> a : this.arcs) {
            if (!a.hasNode(n1) || !a.hasNode(n2)) continue;
            return a;
        }
        throw new IllegalArgumentException(n1 + " " + n2 + "");
    }

    private boolean hasArc(Node<E> n1, Node<E> n2) {
        for (Arc<E> a : this.arcs) {
            if (!a.hasNode(n1) || !a.hasNode(n2)) continue;
            return true;
        }
        return false;
    }

    public int countNodes() {
        return this.nodes.size();
    }

    public int countArcs() {
        return this.arcs.size();
    }

    public Arc<E> getArc(int index) {
        return this.arcs.get(index);
    }

    public void detectCycles() {
        this.cycles = new HashSet<Cycle<E>>();
        Node<E> n = this.nodes.iterator().next();
        System.out.println(n);
        Set<Set<Arc<E>>> parcours = this.treatParcours(new TreeSet<Arc<E>>(), n, null);
        System.out.println(parcours.size());
        for (Set<Arc<E>> parcour : parcours) {
            for (Arc<E> p : parcour) {
                System.out.print(p + " ");
            }
            System.out.println();
        }
    }

    private Set<Set<Arc<E>>> treatParcours(Set<Arc<E>> parcour, Node<E> n, Arc<E> olda) {
        System.out.println("rentre avec " + n);
        HashSet<Set<Arc<Set<Arc<E>>>>> parcours = new HashSet<Set<Arc<Set<Arc<E>>>>>();
        boolean ok = false;
        for (Arc<E> a : n.getArcs()) {
            System.out.println("test de " + a);
            if (parcour.contains(a) || a.equals(olda)) continue;
            ok = true;
            TreeSet<Arc<Arc<E>>> pbis = new TreeSet<Arc<Arc<E>>>();
            pbis.addAll(parcour);
            pbis.add(a);
            System.out.println(a.getNode(n));
            parcours.addAll(this.treatParcours(pbis, a.getNode(n), a));
        }
        if (!ok) {
            parcours.add(parcour);
        }
        return parcours;
    }

    public int countCycles() {
        return this.cycles.size();
    }

    public boolean hasCycle() {
        return this.cycles.size() > 0;
    }
}

