/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.territory;

import fr.inra.sad.bagap.apiland.analysis.Stats;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Facility;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.FarmUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.element.DefaultDynamicLayer;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicLayerType;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.HashSet;
import java.util.Set;

public class FarmTerritory
extends DefaultDynamicLayer<FarmUnit> {
    private static final long serialVersionUID = 1L;

    public FarmTerritory(DynamicLayerType type) {
        super(type);
    }

    public Set<Parcel> parcels() {
        return this.set(Parcel.class);
    }

    public Set<Facility> facilities() {
        return this.set(Facility.class);
    }

    public int getDistanceFromFacilitiesToParcel(String facilities, Parcel parcel) {
        int d = Integer.MAX_VALUE;
        boolean findMoyen = false;
        for (Facility b : this.facilities()) {
            if (!b.containsFacility(facilities)) continue;
            findMoyen = true;
            d = Math.min(d, (int)b.getShape().distance(parcel.getShape()));
        }
        if (!findMoyen) {
            System.out.println("the facilility '" + facilities + "' do not exists on the farm.");
            return -1;
        }
        return d;
    }

    public int totalParcelsArea() {
        int area = 0;
        for (Parcel p : this.parcels()) {
            area += p.getArea();
        }
        return area;
    }

    public void displayParcelAllocation(Instant t) {
        for (Parcel p : this.parcels()) {
            System.out.println("parcel " + p.getId() + " -> " + p.getAttribute("crop").getValue(t));
        }
    }

    public void clearParcels() {
        for (Parcel p : this.parcels()) {
            p.clearAttributes();
        }
    }

    public int totalEdgesLength() {
        double length = 0.0;
        HashSet<Parcel> ever = new HashSet<Parcel>();
        for (Parcel p1 : this.parcels()) {
            ever.add(p1);
            for (Parcel p2 : this.parcels()) {
                if (ever.contains(p2) || !p1.getShape().intersects(p2.getShape())) continue;
                length += p1.getShape().intersection(p2.getShape()).getLength();
            }
        }
        return (int)length;
    }

    public int[] edgesLength() {
        int size = (int)(Math.pow(this.parcels().size(), 2.0) - (double)this.parcels().size()) / 2;
        int[] edgeLength = new int[size];
        HashSet<Parcel> ever = new HashSet<Parcel>();
        int i = 0;
        for (Parcel p1 : this.parcels()) {
            ever.add(p1);
            for (Parcel p2 : this.parcels()) {
                if (ever.contains(p2)) continue;
                if (p1.getShape().intersects(p2.getShape())) {
                    edgeLength[i++] = (int)p1.getShape().intersection(p2.getShape()).getLength();
                    continue;
                }
                edgeLength[i++] = 0;
            }
        }
        return edgeLength;
    }

    @Override
    public void display() {
        System.out.println("ferme " + this.getId());
        Stats sp = new Stats();
        Stats sf = new Stats();
        for (FarmUnit tu : this) {
            if (tu instanceof Parcel) {
                sp.add(((Parcel)tu).getArea());
                continue;
            }
            sf.add(((Facility)tu).getArea());
        }
        sp.calculate();
        sf.calculate();
        System.out.println("nombre de parcelles = " + sp.size());
        System.out.println("surface totale des parcelles = " + sp.getSum());
        System.out.println("surface moyenne des parcelles = " + sp.getAverage());
        System.out.println("nombre des moyens de production = " + sf.size());
        System.out.println("surface totale des moyens de production = " + sf.getSum());
    }
}

