/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.economic.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.EconomicProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.csp.EconomicCoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Set;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;

public class ProfitVariabilityConstraint2
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;
    private EconomicProfil ep;

    public ProfitVariabilityConstraint2(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels, Domain<Integer, Integer> domain) {
        super(code, checkOnly, ConstraintType.ProfitVariability, mode, covers, parcels, domain);
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        EconomicCoverAllocationProblem ecap = (EconomicCoverAllocationProblem)cap;
        this.ep = ecap.getEconomicProfil();
        IntVar profit = VF.bounded((String)"profit", (int)0, (int)200000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.scalar((IntVar[])ecap.coverAreas(), (int[])this.ep.profits(), (IntVar)profit));
        int[][] historicalProfits = this.ep.getHistoricalProfits();
        int nbCombinations = historicalProfits[0].length;
        int nbCovers = ecap.coverAreas().length;
        IntVar[] distances = new IntVar[nbCombinations];
        for (int h = 0; h < nbCombinations; ++h) {
            IntVar profith = VF.bounded((String)("profit" + h), (int)0, (int)200000000, (Solver)ecap.solver());
            int[] hp = new int[nbCovers];
            for (int s = 0; s < nbCovers; ++s) {
                hp[s] = historicalProfits[s][h];
            }
            ecap.solver().post(ICF.scalar((IntVar[])ecap.coverAreas(), (int[])hp, (IntVar)profith));
            distances[h] = VF.bounded((String)("distance" + h), (int)0, (int)200000000, (Solver)ecap.solver());
            ecap.solver().post(ICF.distance((IntVar)profit, (IntVar)profith, (String)"=", (IntVar)distances[h]));
        }
        IntVar sum = VF.bounded((String)"sum", (int)0, (int)200000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.sum((IntVar[])distances, (IntVar)sum));
        switch (this.mode()) {
            case ONLY: {
                this.post(ecap, this.domain(), sum);
                break;
            }
            case NEVER: {
                this.post(ecap, this.domain().inverse(), sum);
                break;
            }
            default: {
                throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
            }
        }
    }

    private void post(CoverAllocationProblem cap, Domain<Integer, Integer> domain, IntVar sum) {
        cap.solver().post(domain.postIntVar(sum));
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        return ok;
    }
}

