/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.economic;

import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import java.util.Set;

public abstract class EconomicProfil {
    public abstract CoverUnit[] getCovers();

    private int getCoverIndex(CoverUnit cu) {
        for (int i = 0; i < this.getCovers().length; ++i) {
            if (!this.getCovers()[i].equals(cu)) continue;
            return i;
        }
        return -1;
    }

    public int[] profits() {
        int[] profits = new int[this.getCovers().length];
        for (int i = 0; i < this.getCovers().length; ++i) {
            profits[i] = this.profit(i);
        }
        return profits;
    }

    protected abstract int profit(int var1);

    public int profit(CoverUnit cu, int area) {
        int p = this.profit(this.getCoverIndex(cu));
        return (int)((double)(p * area) / 10000.0);
    }

    public int[] profits(Set<CoverUnit> cs) {
        int[] profits = new int[this.getCovers().length];
        for (int i = 0; i < this.getCovers().length; ++i) {
            profits[i] = cs.contains(this.getCovers()[i]) ? this.profit(i) : 0;
        }
        return profits;
    }

    public int[][] getHistoricalProfits() {
        int[][] historicalProfits = new int[this.getCovers().length][10];
        for (int i = 0; i < this.getCovers().length; ++i) {
            historicalProfits[i] = this.getHistoricalProfit(i);
        }
        return historicalProfits;
    }

    protected int[] getHistoricalProfit(int coverIndex) {
        throw new UnsupportedOperationException();
    }
}

