/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.VariableValueDomain;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import fr.inra.sad.bagap.apiland.core.time.delay.YearDelay;
import java.util.Set;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.LCF;
import org.chocosolver.solver.variables.IntVar;

public class OnNumericConditionConstraint
extends CoverAllocationConstraint<Double, Parcel> {
    private static final long serialVersionUID = 1L;

    public OnNumericConditionConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> location, Domain<Double, Parcel> domain) {
        super(code, checkOnly, ConstraintType.OnNumericCondition, mode, covers, location, domain);
    }

    protected boolean condition(Parcel p) {
        return ((VariableValueDomain)this.domain()).accept(p);
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        if (this.hasSingleCover()) {
            CoverUnit c = this.getSingleCover();
            int ic = cap.covers().get(c);
            for (Parcel p : this.location()) {
                int ip = cap.parcels().get(p);
                switch (this.mode()) {
                    case ALWAYS: {
                        if (!this.condition(p)) break;
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1));
                        break;
                    }
                    case NEVER: {
                        if (!this.condition(p)) break;
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                        break;
                    }
                    case AROUND: {
                        if (this.condition(p)) break;
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1));
                        break;
                    }
                    case ONLY: {
                        if (this.condition(p)) break;
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                    }
                }
            }
        } else {
            block13: for (Parcel p : this.location()) {
                int ip = cap.parcels().get(p);
                switch (this.mode()) {
                    case ALWAYS: {
                        int ic;
                        if (!this.condition(p)) break;
                        Constraint[] ct = new Constraint[this.covers().size()];
                        int i = 0;
                        for (CoverUnit c : this.covers()) {
                            ic = cap.covers().get(c);
                            ct[i++] = ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1);
                        }
                        cap.solver().post(LCF.or((Constraint[])ct));
                        break;
                    }
                    case NEVER: {
                        if (!this.condition(p)) break;
                        for (CoverUnit c : this.covers()) {
                            int ic = cap.covers().get(c);
                            cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                        }
                        continue block13;
                    }
                    case AROUND: {
                        int ic;
                        if (this.condition(p)) break;
                        Constraint[] ct = new Constraint[this.covers().size()];
                        int i = 0;
                        for (CoverUnit c : this.covers()) {
                            ic = cap.covers().get(c);
                            ct[i++] = ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1);
                        }
                        cap.solver().post(LCF.or((Constraint[])ct));
                        break;
                    }
                    case ONLY: {
                        if (this.condition(p)) break;
                        for (CoverUnit c : this.covers()) {
                            int ic = cap.covers().get(c);
                            cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                        }
                        break;
                    }
                }
            }
        }
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        sb.append("on numeric condition ");
        YearDelay d = new YearDelay(1);
        for (Parcel p : this.location()) {
            Instant t = start;
            while (t.isBefore(end) || t.equals(end)) {
                switch (this.mode()) {
                    case ALWAYS: {
                        if (!this.condition(p) || this.covers().contains(p.getAttribute("cover").getValue(t))) break;
                        ok = false;
                        if (verbose) {
                            sb.append("BAD \n");
                            break;
                        }
                        return ok;
                    }
                    case NEVER: {
                        if (!this.condition(p) || !this.covers().contains(p.getAttribute("cover").getValue(t))) break;
                        ok = false;
                        if (verbose) {
                            sb.append("BAD \n");
                            break;
                        }
                        return ok;
                    }
                    case AROUND: {
                        if (this.condition(p) || this.covers().contains(p.getAttribute("cover").getValue(t))) break;
                        ok = false;
                        if (verbose) {
                            sb.append("BAD \n");
                            break;
                        }
                        return ok;
                    }
                    case ONLY: {
                        if (this.condition(p) || !this.covers().contains(p.getAttribute("cover").getValue(t))) break;
                        ok = false;
                        if (verbose) {
                            sb.append("BAD \n");
                            break;
                        }
                        return ok;
                    }
                }
                t = ((Delay)d).next(t);
            }
        }
        if (verbose) {
            if (ok) {
                sb.append("GOOD : cover " + this.covers().toString() + " is " + (Object)((Object)this.mode()) + " on " + this.domain());
            }
            System.out.println(sb.toString());
        }
        return ok;
    }
}

