/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.Farm;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.io.File;
import java.io.IOException;

public class HistoricFactory {
    public static void init(Farm farm, Instant start) {
        if (farm.hasHistoric()) {
            try {
                File folder = new File(farm.getHistoric());
                String historicFile = null;
                if (folder.isFile()) {
                    historicFile = folder.getAbsolutePath();
                } else {
                    int rH = new Double(Math.random() * (double)folder.list().length).intValue();
                    int i = 0;
                    for (String f : folder.list()) {
                        if (i == rH) {
                            historicFile = folder + "/" + f;
                            break;
                        }
                        ++i;
                    }
                }
                CsvReader cr = new CsvReader(historicFile);
                cr.setDelimiter(';');
                cr.readHeaders();
                while (cr.readRecord()) {
                    int nb;
                    String parcel = cr.get("parcel");
                    String[] sequence = cr.get("seq_cover").replaceAll(" ", "").split("-");
                    int nbYear = 0;
                    for (String cover : sequence) {
                        nb = 1;
                        if (cover.contains("(")) {
                            String[] infos = cover.replace(")", "").split("\\(");
                            cover = infos[0];
                            nb = Integer.parseInt(infos[1]);
                        }
                        nbYear += nb;
                    }
                    Instant t = Instant.get(start.dayOfMonth(), start.month(), start.year() - nbYear);
                    for (String cover : sequence) {
                        nb = 1;
                        if (!cover.equalsIgnoreCase("")) {
                            if (cover.contains("(")) {
                                String[] infos = cover.replace(")", "").split("\\(");
                                cover = infos[0];
                                nb = Integer.parseInt(infos[1]);
                            }
                            farm.parcel(parcel).getAttribute("cover").setValue(t, (CoverUnit)Cover.get(cover));
                        }
                        t = Instant.get(t.dayOfMonth(), t.month(), t.year() + nb);
                    }
                }
                cr.close();
            }
            catch (CsvReader.CatastrophicException | CsvReader.FinalizedException | IOException e) {
                e.printStackTrace();
            }
        }
    }
}

