/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.window;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.analysis.vector.process.VectorProcessType;
import fr.inra.sad.bagap.apiland.analysis.vector.window.MapWindowVectorAnalysis;
import fr.inra.sad.bagap.apiland.analysis.vector.window.SelectedWindowVectorAnalysis;
import fr.inra.sad.bagap.apiland.analysis.vector.window.SlidingWindowVectorAnalysis;
import fr.inra.sad.bagap.apiland.analysis.vector.window.WindowVectorAnalysis;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisType;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class WindowVectorAnalysisBuilder {
    private WindowAnalysisType type;
    private Instant time;
    private double displacement;
    private Set<DynamicLayer<?>> layers;
    private VectorProcessType processType;
    private Set<WindowAnalysisObserver> observers;
    private Map<String, Set<Object>> filters;
    private Map<String, Set<Object>> unfilters;
    private Geometry geomFilter;
    private Set<Point> points;
    private Set<Double> buffers;
    private Set<VectorMetric> metrics;
    private double minRate;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    public WindowVectorAnalysisBuilder(WindowAnalysisType t) {
        this.type = t;
        this.observers = new HashSet<WindowAnalysisObserver>();
        this.filters = new HashMap<String, Set<Object>>();
        this.unfilters = new HashMap<String, Set<Object>>();
        this.points = new TreeSet<Point>(new Comparator<Point>(){

            @Override
            public int compare(Point p1, Point p2) {
                if (p1.getCoordinate().y < p2.getCoordinate().y) {
                    return 1;
                }
                if (p1.getCoordinate().y > p2.getCoordinate().y) {
                    return -1;
                }
                if (p1.getCoordinate().x < p2.getCoordinate().x) {
                    return -1;
                }
                if (p1.getCoordinate().x > p2.getCoordinate().x) {
                    return 1;
                }
                return 0;
            }
        });
        this.buffers = new TreeSet<Double>();
        this.metrics = new TreeSet<VectorMetric>();
        this.layers = new HashSet();
        this.reset();
    }

    private void reset() {
        this.processType = null;
        this.displacement = 1.0;
        this.minRate = 0.0;
        this.minX = -1.0;
        this.maxX = -1.0;
        this.minY = -1.0;
        this.maxY = -1.0;
        this.observers.clear();
        this.filters.clear();
        this.unfilters.clear();
        this.geomFilter = null;
        this.points.clear();
        this.buffers.clear();
        this.metrics.clear();
        this.layers.clear();
    }

    public void setTime(Instant t) {
        this.time = t;
    }

    public void addLayer(DynamicLayer<?> layer) {
        this.layers.add(layer);
    }

    public void addPoint(Point p) {
        this.points.add(p);
    }

    public void addPoints(Set<Point> points) {
        this.points.addAll(points);
    }

    public void addBuffer(double b) {
        this.buffers.add(b);
    }

    public void addBuffers(Set<Double> b) {
        this.buffers.addAll(b);
    }

    public void addMetric(VectorMetric m) {
        this.metrics.add(m);
    }

    public void setDisplacement(int d) {
        this.displacement = d;
    }

    public void setMinRate(double mr) {
        this.minRate = mr;
    }

    public void addObserver(WindowAnalysisObserver o) {
        this.observers.add(o);
    }

    public void addFilter(Geometry g) {
        this.geomFilter = g;
    }

    public void addFilter(String att, Object val) {
        if (!this.filters.containsKey(att)) {
            this.filters.put(att, new HashSet());
        }
        this.filters.get(att).add(val);
    }

    public void setFilters(Map<String, Set<Object>> f) {
        this.filters.putAll(f);
    }

    public void addUnfilter(String att, Object val) {
        if (!this.unfilters.containsKey(att)) {
            this.unfilters.put(att, new HashSet());
        }
        this.unfilters.get(att).add(val);
    }

    public void setUnfilters(Map<String, Set<Object>> f) {
        this.unfilters.putAll(f);
    }

    public void setProcessType(VectorProcessType pt) {
        this.processType = pt;
    }

    public void setEnveloppe(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public <W extends WindowVectorAnalysis> W build() {
        WindowVectorAnalysis wa = null;
        switch (this.type) {
            case SLIDING: {
                wa = new SlidingWindowVectorAnalysis(this.layers.iterator().next(), this.buffers, this.metrics, this.minRate, this.filters, this.unfilters, this.geomFilter, this.displacement, this.time, this.processType, this.minX, this.maxX, this.minY, this.maxY);
                for (WindowAnalysisObserver o : this.observers) {
                    wa.addObserver(o);
                    this.processType.addObserver(o);
                    for (VectorMetric wm : this.metrics) {
                        wm.addObserver(o);
                    }
                }
                break;
            }
            case SELECTED: {
                wa = new SelectedWindowVectorAnalysis(this.layers.iterator().next(), this.buffers, this.metrics, this.minRate, this.filters, this.unfilters, this.points, this.time, this.processType);
                for (WindowAnalysisObserver o : this.observers) {
                    wa.addObserver(o);
                    this.processType.addObserver(o);
                    for (VectorMetric wm : this.metrics) {
                        wm.addObserver(o);
                    }
                }
                break;
            }
            case MAP: {
                wa = new MapWindowVectorAnalysis(this.layers.iterator().next(), this.metrics, this.time, this.processType);
                for (WindowAnalysisObserver o : this.observers) {
                    wa.addObserver(o);
                    this.processType.addObserver(o);
                    for (VectorMetric wm : this.metrics) {
                        wm.addObserver(o);
                    }
                }
                break;
            }
            case GRID: {
                throw new IllegalArgumentException();
            }
        }
        return (W)wa;
    }
}

