/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.metric;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.HashSet;
import java.util.Set;

public class TotalEdgeLengthMetric
extends VectorMetric {
    public TotalEdgeLengthMetric() {
        super(VariableManager.get("TE"));
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        HashSet<Polygon> buffers = new HashSet<Polygon>();
        for (Polygon p : polygons) {
            Polygon buffer = (Polygon)p.buffer(0.5);
            buffer.setUserData(p.getUserData());
            buffers.add(buffer);
        }
        this.value = 0.0;
        HashSet<Polygon> ever = new HashSet<Polygon>();
        for (Polygon p1 : buffers) {
            ever.add(p1);
            for (Polygon p2 : buffers) {
                if (ever.contains(p2) || !p1.intersects((Geometry)p2)) continue;
                Geometry i = p1.intersection((Geometry)p2);
                if (i instanceof Polygon || i instanceof MultiPolygon) {
                    this.value += i.getLength() / 2.0;
                    continue;
                }
                System.out.println(i.getClass());
            }
        }
        if (Double.isNaN(this.value)) {
            this.value = Raster.getNoDataValue();
        }
    }
}

