/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.process.metric;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessObserver;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.MetricOutput;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public abstract class AbstractMetricOutput
implements MetricOutput {
    private DecimalFormat format;

    public AbstractMetricOutput() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        this.format = new DecimalFormat("0.00000", symbols);
    }

    @Override
    public int compareTo(ProcessObserver obs) {
        if (obs instanceof MetricOutput) {
            return 1;
        }
        return -1;
    }

    protected String format(double v) {
        int f = new Double(Math.floor(v)).intValue();
        if (v == (double)f) {
            return f + "";
        }
        return this.format.format(v);
    }

    protected double formatDouble(double v) {
        if (Double.isNaN(v)) {
            return -1.0;
        }
        int f = new Double(Math.floor(v)).intValue();
        if (v == (double)f) {
            return f;
        }
        return Double.parseDouble(this.format.format(v));
    }

    @Override
    public boolean acceptMetric(String metric) {
        return true;
    }

    @Override
    public void notify(Metric m, String metric, double value, Process process) {
    }

    @Override
    public void notify(Process p, ProcessState s) {
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
    }

    @Override
    public void updateProgression(Analysis a, int total) {
    }
}

