/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.shape;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShape;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.CoordinateManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class CircleWindow
extends WindowShape {
    private final int diameter;
    private final int[] filter;
    private int theoricalSize;
    private List<Pixel> addDownList;
    private List<Pixel> removeDownList;
    private List<Pixel> addVerticalDownList;
    private List<Pixel> removeVerticalDownList;
    private List<Pixel> addHorizontalDownList;
    private List<Pixel> removeHorizontalDownList;

    public CircleWindow(int d) {
        this.diameter = d;
        this.filter = new int[this.diameter * this.diameter];
        this.init();
    }

    @Override
    public int theoricalSize() {
        return this.theoricalSize;
    }

    private void init() {
        double rayon = new Double(this.diameter) / 2.0 - 0.5;
        WKTReader wkt = new WKTReader();
        try {
            Point center = (Point)wkt.read("POINT (" + (rayon + 0.5) + " " + (rayon + 0.5) + ")");
            int index = 0;
            this.theoricalSize = 0;
            for (double y = 0.5; y < (double)this.diameter; y += 1.0) {
                for (double x = 0.5; x < (double)this.diameter; x += 1.0) {
                    Point p = (Point)wkt.read("POINT (" + x + " " + y + ")");
                    if (center.distance((Geometry)p) > rayon) {
                        this.filter[index++] = 0;
                        continue;
                    }
                    this.filter[index++] = 1;
                    ++this.theoricalSize;
                }
            }
            index = 0;
            for (int x = 0; x < this.diameter; ++x) {
                if (x == 0) {
                    if (this.filter[index] != 0) {
                        this.filter[index] = 4;
                    }
                } else if (this.filter[index] != 0) {
                    this.filter[index] = this.filter[index - 1] != 0 ? 2 : 4;
                }
                ++index;
            }
            for (int y = 1; y < this.diameter; ++y) {
                for (int x = 0; x < this.diameter; ++x) {
                    if (x == 0) {
                        if (this.filter[index] != 0) {
                            this.filter[index] = this.filter[index - this.diameter] != 0 ? 3 : 4;
                        }
                    } else if (this.filter[index] != 0) {
                        if (this.filter[index - 1] == 0) {
                            this.filter[index] = this.filter[index - this.diameter] == 0 ? 4 : 3;
                        } else if (this.filter[index - this.diameter] == 0) {
                            this.filter[index] = 2;
                        }
                    }
                    ++index;
                }
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int width() {
        return this.diameter;
    }

    @Override
    public int height() {
        return this.diameter;
    }

    @Override
    public int filter(int wx, int wy) {
        return this.filter[wy * this.width() + wx];
    }

    private Pixel pixelByIndex(int index) {
        return new Pixel(index % this.width(), index / this.width());
    }

    private void initLists() {
        if (this.addDownList == null) {
            this.addDownList = new LinkedList<Pixel>();
            this.removeDownList = new LinkedList<Pixel>();
            this.addHorizontalDownList = new LinkedList<Pixel>();
            this.removeHorizontalDownList = new LinkedList<Pixel>();
            this.addVerticalDownList = new LinkedList<Pixel>();
            this.removeVerticalDownList = new LinkedList<Pixel>();
            for (int i = 0; i < this.filter.length; ++i) {
                if (this.filter[i] == 2 || this.filter[i] == 4) {
                    this.removeDownList.add(this.pixelByIndex(i));
                }
                if (i >= this.width() && this.filter[i] == 0 && this.filter[i - this.width()] != 0) {
                    this.addDownList.add(this.pixelByIndex(i));
                }
                if (i < this.width() && this.filter[i] == 2) {
                    this.removeHorizontalDownList.add(this.pixelByIndex(i));
                }
                if (!(i < this.width() || i % this.width() == 0 || this.filter[i] != 1 && this.filter[i] != 2 || this.filter[i - this.width()] != 0 && this.filter[i - this.width()] != 3 && this.filter[i - this.width()] != 4)) {
                    this.removeHorizontalDownList.add(this.pixelByIndex(i));
                }
                if (!(i < this.width() || i % this.width() == 0 || this.filter[i] != 0 && this.filter[i] != 3 && this.filter[i] != 4 || this.filter[i - this.width()] != 1 && this.filter[i - this.width()] != 2)) {
                    this.addHorizontalDownList.add(this.pixelByIndex(i));
                }
                if (!(i < this.width() || this.filter[i] != 1 && this.filter[i] != 3 || this.filter[i - this.width()] != 0 && this.filter[i - this.width()] != 2 && this.filter[i - this.width()] != 4)) {
                    this.removeVerticalDownList.add(this.pixelByIndex(i));
                }
                if (i < this.width() || this.filter[i] != 0 && this.filter[i] != 2 && this.filter[i] != 4 || this.filter[i - this.width()] != 1 && this.filter[i - this.width()] != 3) continue;
                this.addVerticalDownList.add(this.pixelByIndex(i));
            }
        }
    }

    @Override
    public List<Pixel> removeDownList() {
        this.initLists();
        return this.removeDownList;
    }

    @Override
    public List<Pixel> addDownList() {
        this.initLists();
        return this.addDownList;
    }

    @Override
    public List<Pixel> removeHorizontalDownList() {
        this.initLists();
        return this.removeHorizontalDownList;
    }

    @Override
    public List<Pixel> addHorizontalDownList() {
        this.initLists();
        return this.addHorizontalDownList;
    }

    @Override
    public List<Pixel> removeVerticalDownList() {
        this.initLists();
        return this.removeVerticalDownList;
    }

    @Override
    public List<Pixel> addVerticalDownList() {
        this.initLists();
        return this.addVerticalDownList;
    }

    @Override
    public void display() {
        int index = 0;
        for (int f : this.filter) {
            System.out.print(f + " ");
            if (++index % this.diameter != 0) continue;
            System.out.println();
        }
    }

    @Override
    public void export(int x, int y, Matrix m, String path) {
        try {
            String name = new File(m.getFile()).getName().replace(".asc", "");
            String file = path + name + "_circle_" + this.diameter + "_" + CoordinateManager.getProjectedX(m, x) + "-" + CoordinateManager.getProjectedY(m, y) + ".asc";
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            double delta = (double)this.diameter / 2.0;
            double X = CoordinateManager.getProjectedX(m, x);
            double nX = X - delta * Raster.getCellSize();
            double Y = CoordinateManager.getProjectedY(m, y);
            double nY = Y - delta * Raster.getCellSize();
            out.write("ncols ");
            out.write(this.diameter + "");
            out.newLine();
            out.write("nrows ");
            out.write(this.diameter + "");
            out.newLine();
            out.write("xllcorner ");
            out.write(nX + "");
            out.newLine();
            out.write("yllcorner ");
            out.write(nY + "");
            out.newLine();
            out.write("cellsize ");
            out.write(Raster.getCellSize() + "");
            out.newLine();
            out.write("NODATA_value  ");
            out.write(Raster.getNoDataValue() + "");
            out.newLine();
            int index = 0;
            for (int j = y - this.diameter / 2; j < y + 1 + this.diameter / 2; ++j) {
                for (int i = x - this.diameter / 2; i < x + 1 + this.diameter / 2; ++i) {
                    if (this.filter[index++] == 0) {
                        out.write("-1 ");
                        continue;
                    }
                    out.write(m.get(i, j) + " ");
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void infos() {
    }
}

