/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.GridWindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.MapWindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.SelectedWindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.SlidingWindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.Window;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.HashSet;
import java.util.Set;

public class WindowMatrixAnalysisBuilder {
    private WindowAnalysisType type;
    private Set<Matrix> matrix;
    private Window window;
    private WindowMatrixProcessType processType;
    private int displacement;
    private Set<WindowAnalysisObserver> observers;
    private Matrix matrixFilter;
    private Matrix matrixUnFilter;
    private Set<Integer> filters;
    private Set<Integer> unfilters;
    private Set<Pixel> pixels;
    private double minRate;
    private String path;

    public WindowMatrixAnalysisBuilder(WindowAnalysisType t) {
        this.type = t;
        this.observers = new HashSet<WindowAnalysisObserver>();
        this.filters = new HashSet<Integer>();
        this.unfilters = new HashSet<Integer>();
        this.matrix = new HashSet<Matrix>();
        this.reset();
    }

    private void reset() {
        this.window = null;
        this.processType = null;
        this.displacement = 1;
        this.minRate = 0.0;
        this.observers.clear();
        this.filters.clear();
        this.unfilters.clear();
        this.matrix.clear();
        this.matrixFilter = null;
        this.matrixUnFilter = null;
        this.path = null;
    }

    public void addMatrix(Matrix m) {
        this.matrix.add(m);
    }

    public void setMatrix(Set<Matrix> m) {
        this.matrix.addAll(m);
    }

    public void setWindow(Window w) {
        this.window = w;
    }

    public void setProcessType(WindowMatrixProcessType pt) {
        this.processType = pt;
    }

    public void setDisplacement(int d) {
        this.displacement = d;
    }

    public void setMinRate(double mr) {
        this.minRate = mr;
    }

    public void setPixels(Set<Pixel> p) {
        this.pixels = p;
    }

    public void addObserver(WindowAnalysisObserver o) {
        this.observers.add(o);
    }

    public void addFilter(Matrix m) {
        this.matrixFilter = m;
    }

    public void addFilter(int f) {
        this.filters.add(f);
    }

    public void setFilters(Set<Integer> f) {
        this.filters.addAll(f);
    }

    public void addUnFilter(Matrix m) {
        this.matrixUnFilter = m;
    }

    public void addUnfilter(int f) {
        this.unfilters.add(f);
    }

    public void setUnfilters(Set<Integer> f) {
        this.unfilters.addAll(f);
    }

    public void setPath(String path) {
        this.path = path.endsWith("/") ? path : path + "/";
    }

    public <W extends WindowMatrixAnalysis> W build() {
        WindowMatrixAnalysis wa = null;
        Matrix[] mat = new Matrix[this.matrix.size()];
        int index = 0;
        for (Matrix m : this.matrix) {
            mat[index++] = m;
        }
        switch (this.type) {
            case SLIDING: {
                wa = new SlidingWindowMatrixAnalysis(mat[0], this.window, this.processType, this.displacement, this.minRate, this.filters, this.unfilters, this.matrixFilter, this.matrixUnFilter);
                for (WindowAnalysisObserver o : this.observers) {
                    wa.addObserver(o);
                    this.processType.addObserver(o);
                    for (Metric wm : this.processType.metrics()) {
                        wm.addObserver(o);
                    }
                }
                break;
            }
            case SELECTED: {
                wa = new SelectedWindowMatrixAnalysis(mat[0], this.window, this.processType, this.minRate, this.pixels, this.path);
                for (WindowAnalysisObserver o : this.observers) {
                    wa.addObserver(o);
                    this.processType.addObserver(o);
                    for (Metric wm : this.processType.metrics()) {
                        wm.addObserver(o);
                    }
                }
                break;
            }
            case MAP: {
                wa = new MapWindowMatrixAnalysis(mat[0], this.window, this.processType, this.matrixFilter, this.matrixUnFilter);
                for (WindowAnalysisObserver o : this.observers) {
                    wa.addObserver(o);
                    this.processType.addObserver(o);
                    for (Metric wm : this.processType.metrics()) {
                        wm.addObserver(o);
                    }
                }
                break;
            }
            case GRID: {
                wa = new GridWindowMatrixAnalysis(mat[0], this.window, this.processType, this.displacement, this.minRate);
                for (WindowAnalysisObserver o : this.observers) {
                    wa.addObserver(o);
                    this.processType.addObserver(o);
                    for (Metric wm : this.processType.metrics()) {
                        wm.addObserver(o);
                    }
                }
                break;
            }
        }
        this.reset();
        return (W)wa;
    }
}

