/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting;

import fr.inra.sad.bagap.apiland.analysis.Stats;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingDecorator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.util.HashMap;
import java.util.Map;

public class ClassCounting
extends CountingDecorator {
    private Map<Object, Counting.Count> counts;
    private Stats stats;

    public ClassCounting(Counting decorate) {
        super(decorate);
    }

    @Override
    public void doInit() {
        this.counts = new HashMap<Object, Counting.Count>();
    }

    @Override
    protected void doAdd(double value, int x, int y, int filter, double ch, double cv) {
        if (value != (double)Raster.getNoDataValue()) {
            if (!this.counts.containsKey(value)) {
                this.counts.put(value, new Counting.Count(this));
            }
            this.counts.get(value).add();
        }
    }

    @Override
    public void doAddValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            if (!this.counts.containsKey(value)) {
                this.counts.put(value, new Counting.Count(this));
            }
            this.counts.get(value).add();
        }
    }

    @Override
    public void doRemoveValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            this.counts.get(value).minus();
            if (this.counts.get(value).get() == 0) {
                this.counts.remove(value);
            }
        }
    }

    @Override
    public void doDelete() {
        this.counts.clear();
        this.counts = null;
        this.stats = null;
    }

    @Override
    protected void doDown() {
        this.stats = null;
    }

    @Override
    public int countClass() {
        if (this.counts.containsKey(0.0)) {
            return this.counts.size() - 1;
        }
        return this.counts.size();
    }

    @Override
    public double averageClass() {
        this.calculate();
        return this.stats.getAverage();
    }

    @Override
    public double varianceClass() {
        this.calculate();
        return this.stats.getVariance();
    }

    @Override
    public double standardDeviationClass() {
        this.calculate();
        return this.stats.getStandardDeviation();
    }

    private void calculate() {
        if (this.stats == null) {
            this.stats = new Stats();
            for (Counting.Count c : this.counts.values()) {
                this.stats.add(c.get());
            }
            this.stats.calculate();
        }
    }
}

