/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.SimpleWindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;

public class BasicCounting
extends Counting {
    private int countValues;
    private int totalValues;
    private int validValues;

    @Override
    public void init() {
        this.countValues = 0;
        this.totalValues = 0;
        this.validValues = 0;
    }

    @Override
    public SimpleWindowMatrixProcess process() {
        return (SimpleWindowMatrixProcess)super.process();
    }

    @Override
    public void add(double value, int x, int y, int filter, double ch, double cv) {
        this.addValue(value, x, y);
    }

    @Override
    public void addValue(double value, int x, int y) {
        ++this.totalValues;
        if (value != (double)Raster.getNoDataValue()) {
            ++this.validValues;
            if (value != 0.0) {
                ++this.countValues;
            }
        }
    }

    @Override
    public void addCouple(double couple) {
    }

    @Override
    public void removeValue(double value, int x, int y) {
        --this.totalValues;
        if (value != (double)Raster.getNoDataValue()) {
            --this.validValues;
            if (value != 0.0) {
                --this.countValues;
            }
        }
    }

    @Override
    public void removeCouple(double couple) {
    }

    @Override
    public void down() {
        int outy;
        int outx;
        for (Pixel p : this.process().window().removeDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width()) continue;
            this.process().counting().removeValue(this.process().values()[p.y()][p.x()], p.x(), p.y());
        }
        for (Pixel p : this.process().window().addDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width()) continue;
            this.process().counting().addValue(this.process().values()[p.y()][p.x()], p.x(), p.y());
        }
    }

    @Override
    public void delete() {
    }

    @Override
    public int totalValues() {
        return this.totalValues;
    }

    @Override
    public int validValues() {
        return this.validValues;
    }

    @Override
    public int theoricalSize() {
        return this.process().window().theoricalSize();
    }

    @Override
    public int countValues() {
        return this.countValues;
    }
}

