/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.MultipleWindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.SimpleWindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetric;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.MultipleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.Window;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class MultipleWindowMatrixProcess
extends WindowMatrixProcess {
    private double[][] values;
    private Map<Window, SimpleWindowMatrixProcess> processes;

    public MultipleWindowMatrixProcess(Window w, Pixel p, MultipleWindowMatrixProcessType wpt) {
        super(w, p, wpt);
        this.values = new double[w.height()][w.width()];
        for (int y = 0; y < this.values.length; ++y) {
            Arrays.fill(this.values[y], -1.0);
        }
    }

    @Override
    public MultipleWindow window() {
        return (MultipleWindow)super.window();
    }

    public Window[] windows() {
        return this.window().windows();
    }

    public Map<Window, SimpleWindowMatrixProcess> processes() {
        return this.processes;
    }

    public void setProcesses(Map<Window, SimpleWindowMatrixProcess> p) {
        this.processes = p;
    }

    @Override
    public void calculateMetrics() {
        assert (this.state() == ProcessState.READY);
        for (Map.Entry<Window, SimpleWindowMatrixProcess> p : this.processes().entrySet()) {
            for (Metric m : this.processType().metrics()) {
                ((MatrixMetric)m).calculate(p.getValue(), "w" + p.getKey().width() + "_");
            }
        }
        this.setState(ProcessState.DONE);
    }

    @Override
    public void unCalculateMetrics() {
        assert (this.state() == ProcessState.READY);
        for (Map.Entry<Window, SimpleWindowMatrixProcess> p : this.processes().entrySet()) {
            for (Metric m : this.processType().metrics()) {
                ((MatrixMetric)m).unCalculate(p.getValue(), "w" + p.getKey().width() + "_");
            }
        }
        this.setState(ProcessState.DONE);
    }

    @Override
    public void init() {
        if (this.state().equals((Object)ProcessState.IDLE)) {
            this.setProcesses(new TreeMap<Window, SimpleWindowMatrixProcess>());
            for (Window w : this.windows()) {
                SimpleWindowMatrixProcess process = new SimpleWindowMatrixProcess(w, new Pixel(this.pixel().x(), this.pixel().y()), this.processType());
                process.init();
                process.setMaxSize(w.size(this.processType().matrix().width(), this.processType().matrix().height()));
                this.processes().put(w, process);
            }
            this.setMaxSize(this.windows()[0].size(this.processType().matrix().width(), this.processType().matrix().height()));
            this.setState(ProcessState.INIT);
        }
    }

    @Override
    public boolean add(int x, int y, double v) {
        this.window().locate(this.pixel());
        boolean ok = false;
        if (this.window().accept(x, y)) {
            ok = true;
            this.init();
            this.addCurrentSize();
            int inX = this.window().toXWindow(x);
            int inY = this.window().toYWindow(y);
            this.values[inY][inX] = v;
            for (Window w : this.windows()) {
                if (!this.processes.get(w).addQuiet(x, y, v)) break;
            }
            if (this.currentSize() == this.maxSize()) {
                this.setState(ProcessState.READY);
            }
        }
        return ok;
    }

    @Override
    public void delete() {
        for (WindowMatrixProcess windowMatrixProcess : this.processes().values()) {
            windowMatrixProcess.delete();
        }
        this.processes().clear();
        this.setProcesses(null);
    }

    @Override
    public void down(int delta) {
        if (this.pixel().y() < this.processType().matrix().height() - delta) {
            for (int d = 0; d < delta; ++d) {
                this.down();
            }
            int place = 0;
            int old = -1;
            for (Map.Entry<Window, SimpleWindowMatrixProcess> p : this.processes().entrySet()) {
                if (old != -1) {
                    place += (old - p.getKey().width()) / 2;
                }
                p.getValue().downQuiet(delta, this.values, place);
                old = p.getKey().width();
            }
            this.window().locate(this.pixel());
            this.setMaxSize(this.windows()[0].size(this.processType().matrix().width(), this.processType().matrix().height()));
            if (this.currentSize() == this.maxSize()) {
                this.setState(ProcessState.FINISH);
            } else {
                this.setState(ProcessState.INIT);
            }
        }
    }

    private void down() {
        this.window().locate(this.pixel());
        if (this.pixel().y() >= this.windows()[0].height() / 2) {
            for (int x = 0; x < this.windows()[0].width(); ++x) {
                if (this.pixel().x() - this.windows()[0].width() / 2 + x < 0 || this.pixel().x() - this.windows()[0].width() / 2 + x >= this.processType().matrix().width()) continue;
                this.minusCurrentSize();
            }
        }
        for (int y = 1; y < this.values.length; ++y) {
            for (int x = 0; x < this.values[y].length; ++x) {
                this.values[y - 1][x] = this.values[y][x];
            }
        }
        Arrays.fill(this.values[this.values.length - 1], -1.0);
        this.pixel().setY(this.pixel().y() + 1);
    }
}

