/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.pixel;

import fr.inra.sad.bagap.apiland.analysis.matrix.pixel.CombinationBaseListener;
import fr.inra.sad.bagap.apiland.analysis.matrix.pixel.CombinationParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.antlr.v4.runtime.misc.NotNull;

public class Pixel2PixelCombinationListener1
extends CombinationBaseListener {
    private Map<String, Double> matrix;
    private double evaluation;
    private List<String> variables = new ArrayList<String>();
    private double operationValue;
    private double leftOperationValue;
    private double rightOperationValue;
    private String boolop;
    private String logicalop;
    private boolean condition;
    private boolean active;
    private boolean logic;
    private Map<String, Expression> expressions = new HashMap<String, Expression>();

    @Override
    public void enterEvaluate(@NotNull CombinationParser.EvaluateContext ctx) {
        this.active = true;
        this.logic = false;
    }

    public void setMatrix(Map<String, Double> matrix) {
        this.matrix = matrix;
    }

    public double evaluate() {
        return this.evaluation;
    }

    @Override
    public void exitBoolterm(@NotNull CombinationParser.BooltermContext ctx) {
        this.logic = false;
    }

    @Override
    public void enterBoolop(@NotNull CombinationParser.BoolopContext ctx) {
        this.boolop = ctx.getText();
    }

    @Override
    public void exitLeftoperation(@NotNull CombinationParser.LeftoperationContext ctx) {
        this.leftOperationValue = this.operationValue;
    }

    @Override
    public void exitRightoperation(@NotNull CombinationParser.RightoperationContext ctx) {
        this.rightOperationValue = this.operationValue;
        boolean localcondition = false;
        switch (this.boolop) {
            case "==": {
                if (this.leftOperationValue == this.rightOperationValue) {
                    localcondition = true;
                    break;
                }
                localcondition = false;
                break;
            }
            case "!=": {
                if (this.leftOperationValue != this.rightOperationValue) {
                    localcondition = true;
                    break;
                }
                localcondition = false;
                break;
            }
            case ">": {
                if (this.leftOperationValue > this.rightOperationValue) {
                    localcondition = true;
                    break;
                }
                localcondition = false;
                break;
            }
            case ">=": {
                if (this.leftOperationValue >= this.rightOperationValue) {
                    localcondition = true;
                    break;
                }
                localcondition = false;
                break;
            }
            case "<": {
                if (this.leftOperationValue < this.rightOperationValue) {
                    localcondition = true;
                    break;
                }
                localcondition = false;
                break;
            }
            case "<=": {
                localcondition = this.leftOperationValue <= this.rightOperationValue;
            }
        }
        if (this.logic) {
            switch (this.logicalop) {
                case "&": {
                    this.condition &= localcondition;
                    break;
                }
                case "&&": {
                    this.condition &= localcondition;
                    break;
                }
                case "AND": {
                    this.condition &= localcondition;
                    break;
                }
                case "|": {
                    this.condition |= localcondition;
                    break;
                }
                case "||": {
                    this.condition |= localcondition;
                    break;
                }
                case "OR": {
                    this.condition |= localcondition;
                }
            }
        } else {
            this.condition = localcondition;
        }
    }

    @Override
    public void enterLogicalop(@NotNull CombinationParser.LogicalopContext ctx) {
        this.logicalop = ctx.getText();
        this.logic = true;
    }

    @Override
    public void enterOperation(@NotNull CombinationParser.OperationContext ctx) {
        this.variables.clear();
    }

    @Override
    public void exitOperation(@NotNull CombinationParser.OperationContext ctx) {
        if (this.active) {
            Expression e = null;
            System.out.println("pass " + ctx.getText());
            this.expressions.put(ctx.getText(), new ExpressionBuilder(ctx.getText()).variables(this.variables.toArray(new String[this.variables.size()])).build());
            e = this.expressions.get(ctx.getText());
            for (String v : this.variables) {
                e.setVariable(v, this.matrix.get(v).doubleValue());
            }
            this.evaluation = this.operationValue = e.evaluate();
        }
    }

    @Override
    public void enterMatrix(@NotNull CombinationParser.MatrixContext ctx) {
        this.variables.add(ctx.getText());
    }

    @Override
    public void enterIfcombination(@NotNull CombinationParser.IfcombinationContext ctx) {
        this.active = this.condition;
    }

    @Override
    public void enterElsecombination(@NotNull CombinationParser.ElsecombinationContext ctx) {
        this.active = !this.condition;
    }
}

