/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import java.text.DecimalFormat;

public class SplineUniform {
    int n;
    int last_interval;
    int[] x;
    double[] f;
    double[] b;
    double[] c;
    double[] d;

    public SplineUniform(int[] xx, double[] ff) {
        int k;
        int i;
        double zero = 0.0;
        double two = 2.0;
        double three = 3.0;
        this.last_interval = 0;
        this.n = xx.length;
        if (this.n <= 3) {
            System.out.println("not enough points to build spline, n=" + this.n);
            return;
        }
        if (this.n != ff.length) {
            System.out.println("not same number of x and f(x)");
            return;
        }
        this.x = new int[this.n];
        this.f = new double[this.n];
        this.b = new double[this.n];
        this.c = new double[this.n];
        this.d = new double[this.n];
        for (i = 0; i < this.n; ++i) {
            this.x[i] = xx[i];
            this.f[i] = ff[i];
        }
        this.b[0] = this.x[1] - this.x[0];
        this.c[0] = (this.f[1] - this.f[0]) / this.b[0];
        if (this.n == 2) {
            this.b[0] = this.c[0];
            this.c[0] = 0.0;
            this.d[0] = 0.0;
            this.b[1] = this.b[0];
            this.c[1] = 0.0;
            return;
        }
        this.d[0] = 2.0 * this.b[0];
        for (i = 1; i < this.n - 1; ++i) {
            this.b[i] = this.x[i + 1] - this.x[i];
            this.c[i] = (this.f[i + 1] - this.f[i]) / this.b[i];
            this.d[i] = 2.0 * (this.b[i] + this.b[i - 1]);
        }
        this.d[this.n - 1] = 2.0 * this.b[this.n - 2];
        double fp1 = this.c[0] - this.b[0] * (this.c[1] - this.c[0]) / (this.b[0] + this.b[1]);
        if (this.n > 3) {
            fp1 += this.b[0] * ((this.b[0] + this.b[1]) * (this.c[2] - this.c[1]) / (this.b[1] + this.b[2]) - this.c[1] + this.c[0]) / (double)(this.x[3] - this.x[0]);
        }
        double fpn = this.c[this.n - 2] + this.b[this.n - 2] * (this.c[this.n - 2] - this.c[this.n - 3]) / (this.b[this.n - 3] + this.b[this.n - 2]);
        if (this.n > 3) {
            fpn += this.b[this.n - 2] * (this.c[this.n - 2] - this.c[this.n - 3] - (this.b[this.n - 3] + this.b[this.n - 2]) * (this.c[this.n - 3] - this.c[this.n - 4]) / (this.b[this.n - 3] + this.b[this.n - 4])) / (double)(this.x[this.n - 1] - this.x[this.n - 4]);
        }
        this.c[this.n - 1] = 3.0 * (fpn - this.c[this.n - 2]);
        for (i = this.n - 2; i > 0; --i) {
            this.c[i] = 3.0 * (this.c[i] - this.c[i - 1]);
        }
        this.c[0] = 3.0 * (this.c[0] - fp1);
        for (k = 1; k < this.n; ++k) {
            double p = this.b[k - 1] / this.d[k - 1];
            this.d[k] = this.d[k] - p * this.b[k - 1];
            this.c[k] = this.c[k] - p * this.c[k - 1];
        }
        this.c[this.n - 1] = this.c[this.n - 1] / this.d[this.n - 1];
        for (k = this.n - 2; k >= 0; --k) {
            this.c[k] = (this.c[k] - this.b[k] * this.c[k + 1]) / this.d[k];
        }
        double h = this.x[1] - this.x[0];
        for (i = 0; i < this.n - 1; ++i) {
            h = this.x[i + 1] - this.x[i];
            this.d[i] = (this.c[i + 1] - this.c[i]) / (3.0 * h);
            this.b[i] = (this.f[i + 1] - this.f[i]) / h - h * (this.c[i] + h * this.d[i]);
        }
        this.b[this.n - 1] = this.b[this.n - 2] + h * (2.0 * this.c[this.n - 2] + h * 3.0 * this.d[this.n - 2]);
    }

    public double spline_value(double t) {
        if (this.n <= 1) {
            System.out.println("not enough points to compute value");
            return 0.0;
        }
        int interval = this.last_interval;
        if (t < (double)this.x[0]) {
            System.out.println("requested point below Spline region");
            return 0.0;
        }
        if (t > (double)this.x[this.n - 1]) {
            System.out.println("requested point above Spline region");
            return 0.0;
        }
        if (t > (double)this.x[this.n - 2]) {
            interval = this.n - 2;
        } else if (t >= (double)this.x[this.last_interval]) {
            int j = this.last_interval;
            while (j < this.n && t >= (double)this.x[j]) {
                interval = j++;
            }
        } else {
            int j = this.last_interval;
            while (t < (double)this.x[j]) {
                interval = j - 1;
                --j;
            }
        }
        this.last_interval = interval;
        double dt = t - (double)this.x[interval];
        double s = this.f[interval] + dt * (this.b[interval] + dt * (this.c[interval] + dt * this.d[interval]));
        return s;
    }

    public static void main(String[] args) {
        DecimalFormat format = new DecimalFormat("0.00000");
        int[] xx = new int[]{0, 4, 8, 12};
        double[] ff = new double[]{0.54246, 0.60494, 0.66435, 0.70204};
        SplineUniform spline = new SplineUniform(xx, ff);
        for (int i = 0; i <= 12; ++i) {
            System.out.print(format.format(spline.spline_value(i)) + ";");
        }
    }
}

