/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.MultipleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.SimpleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.Window;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.CoordinateManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class InterpolateLinearSplineCsvOutput
extends AbstractMetricOutput {
    private Matrix matrix;
    private CsvWriter out;
    private int delta;
    private String file;
    private int width;
    private int height;
    private int maxWidth;
    private int maxHeight;
    private Map<String, Double[]> values_d;
    private Map<String, Map<Integer, Double[]>> values;

    public InterpolateLinearSplineCsvOutput(Matrix m, String f, int d) {
        this.matrix = m;
        this.file = f;
        this.delta = d;
    }

    public String toString() {
        return "csv";
    }

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)ma);
                break;
            }
            case RUNNING: {
                this.notifyAnalysisRun((WindowMatrixAnalysis)ma);
                break;
            }
            case FINISH: {
                this.notifyAnalysisFinish((WindowMatrixAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis wa) {
        this.out = new CsvWriter(this.file);
        this.out.setDelimiter(';');
        this.width = wa.matrix().width();
        this.maxWidth = this.width - (this.width - 1) % this.delta - 1;
        this.height = wa.matrix().height();
        this.maxHeight = this.height - (this.height - 1) % this.delta - 1;
        this.values = new TreeMap<String, Map<Integer, Double[]>>();
        this.values_d = new TreeMap<String, Double[]>();
        if (wa.window() instanceof MultipleWindow) {
            for (Window w : ((MultipleWindow)wa.window()).windows()) {
                for (Metric metric : wa.metrics()) {
                    this.values.put("w" + ((SimpleWindow)w).diameter() + "_" + metric.getName(), new TreeMap());
                    this.values.get("w" + ((SimpleWindow)w).diameter() + "_" + metric.getName()).put(0, new Double[this.width]);
                    for (int i = 0; i < this.width; ++i) {
                        this.values.get((Object)new StringBuilder().append((String)"w").append((int)((SimpleWindow)w).diameter()).append((String)"_").append((String)metric.getName()).toString()).get((Object)Integer.valueOf((int)0))[i] = Raster.getNoDataValue();
                    }
                    this.values_d.put("w" + ((SimpleWindow)w).diameter() + "_" + metric.getName(), new Double[this.width]);
                }
            }
        } else {
            for (Metric metric : wa.metrics()) {
                this.values.put(metric.getName(), new TreeMap());
                this.values.get(metric.getName()).put(0, new Double[this.width]);
                for (int i = 0; i < this.width; ++i) {
                    this.values.get((Object)metric.getName()).get((Object)Integer.valueOf((int)0))[i] = Raster.getNoDataValue();
                }
                this.values_d.put(metric.getName(), new Double[this.width]);
            }
        }
    }

    private void notifyAnalysisRun(WindowMatrixAnalysis a) {
        try {
            this.out.write("X");
            this.out.write("Y");
            for (String v : this.values.keySet()) {
                this.out.write(v);
            }
            this.out.endRecord();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyAnalysisFinish(WindowMatrixAnalysis a) {
        this.out.close();
    }

    @Override
    public void notify(Metric m, String metric, double v, Process p) {
        int x = ((WindowMatrixProcess)p).x();
        int y = ((WindowMatrixProcess)p).y();
        if (!this.values.get(metric).containsKey(y)) {
            for (int i = 0; i < this.width; ++i) {
                this.values_d.get((Object)metric)[i] = this.values.get(metric).get(y - this.delta)[i];
            }
            for (int yv = 1; yv <= this.delta; ++yv) {
                this.values.get(metric).put(y - this.delta + yv, new Double[this.width]);
                for (int i = 0; i < this.width; ++i) {
                    this.values.get((Object)metric).get((Object)Integer.valueOf((int)(y - this.delta + yv)))[i] = Raster.getNoDataValue();
                }
            }
        }
        this.values.get((Object)metric).get((Object)Integer.valueOf((int)y))[x] = v;
    }

    private double droite(double v_delta, double v, double yv) {
        if (v == (double)Raster.getNoDataValue() || v_delta == (double)Raster.getNoDataValue()) {
            return Raster.getNoDataValue();
        }
        return yv * (v - v_delta) / (double)this.delta + v_delta;
    }

    @Override
    public void notify(Process p, ProcessState s) {
        switch (s) {
            case DONE: {
                this.notifyProcessDone((WindowMatrixProcess)p);
            }
        }
    }

    protected void notifyProcessDone(WindowMatrixProcess p) {
        int im;
        int yy;
        int yv;
        Object vv;
        int x = p.x();
        int y = p.y();
        if (y != 0 && x == 0) {
            vv = new double[this.values.keySet().size()];
            if (y > this.delta) {
                for (yv = 1; yv <= this.delta; ++yv) {
                    yy = y - 2 * this.delta + yv;
                    for (int i = 0; i < this.width; ++i) {
                        im = 0;
                        for (String m : this.values.keySet()) {
                            vv[im++] = this.values.get(m).get(yy)[i];
                        }
                        this.write((double[])vv, i, yy);
                    }
                    for (String m : this.values.keySet()) {
                        this.values.get(m).remove(yy);
                    }
                }
            } else {
                for (int i = 0; i < this.width; ++i) {
                    im = 0;
                    for (String m : this.values.keySet()) {
                        vv[im++] = this.values.get(m).get(0)[i];
                    }
                    this.write((double[])vv, i, 0);
                }
            }
        }
        for (String m : this.values.keySet()) {
            int xv;
            double v;
            if (y == 0) {
                if (x == 0) {
                    for (int i = 1; i < this.width; ++i) {
                        this.values.get((Object)m).get((Object)Integer.valueOf((int)0))[i] = Raster.getNoDataValue();
                    }
                    continue;
                }
                v = this.values.get(m).get(0)[x];
                for (xv = 1; xv < this.delta; ++xv) {
                    this.values.get((Object)m).get((Object)Integer.valueOf((int)0))[x - this.delta + xv] = this.droite(this.values.get(m).get(0)[x - this.delta], v, xv);
                }
                continue;
            }
            if (x == 0) {
                v = this.values.get(m).get(y)[0];
                for (int yv2 = 1; yv2 < this.delta; ++yv2) {
                    this.values.get((Object)m).get((Object)Integer.valueOf((int)(y - this.delta + yv2)))[0] = this.droite(this.values_d.get(m)[0], v, yv2);
                }
                continue;
            }
            v = this.values.get(m).get(y)[x];
            for (xv = 1; xv < this.delta; ++xv) {
                this.values.get((Object)m).get((Object)Integer.valueOf((int)y))[x - this.delta + xv] = this.droite(this.values.get(m).get(y)[x - this.delta], v, xv);
            }
            for (int yv3 = 1; yv3 < this.delta; ++yv3) {
                double vh = this.droite(this.values_d.get(m)[x], v, yv3);
                this.values.get((Object)m).get((Object)Integer.valueOf((int)(y - this.delta + yv3)))[x] = vh;
                for (int xv2 = 1; xv2 < this.delta; ++xv2) {
                    this.values.get((Object)m).get((Object)Integer.valueOf((int)(y - this.delta + yv3)))[x - this.delta + xv2] = this.droite(this.values.get(m).get(y - this.delta + yv3)[x - this.delta], vh, xv2);
                }
            }
        }
        if (y == this.maxHeight && x == this.maxWidth) {
            vv = new double[this.values.keySet().size()];
            for (yv = 1; yv <= this.delta; ++yv) {
                yy = y - this.delta + yv;
                for (int i = 0; i < this.width; ++i) {
                    im = 0;
                    for (String m : this.values.keySet()) {
                        vv[im++] = this.values.get(m).get(yy)[i];
                    }
                    this.write((double[])vv, i, yy);
                }
            }
            for (int j = this.maxHeight + 1; j < this.height; ++j) {
                for (int i = 0; i < this.width; ++i) {
                    im = 0;
                    for (String m : this.values.keySet()) {
                        vv[im++] = (double)Raster.getNoDataValue();
                    }
                    this.write((double[])vv, i, j);
                }
            }
        }
    }

    private void write(double[] vv, int x, int y) {
        try {
            this.out.write(CoordinateManager.getProjectedX(this.matrix, x) + "");
            this.out.write(CoordinateManager.getProjectedY(this.matrix, y) + "");
            for (double v : vv) {
                this.out.write(this.format(v));
            }
            this.out.endRecord();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

