/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.agriconnect.model.metric;

import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.HashMap;
import java.util.Set;

public class ShannonMetric
extends VectorMetric {
    private Set<CoverGroup> codes;

    public ShannonMetric(Set<CoverGroup> codes) {
        super(VariableManager.get("SHDI"));
        this.codes = codes;
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        HashMap<CoverGroup, VectorMetric.Count> areas = new HashMap<CoverGroup, VectorMetric.Count>();
        for (CoverGroup code : this.codes) {
            areas.put(code, new VectorMetric.Count(this));
        }
        double total = 0.0;
        block1: for (Polygon p : polygons) {
            total += p.getArea();
            Cover code = (Cover)((Composition)p.getUserData()).getAttribute("cover").getValue(t);
            for (CoverGroup coverGroup : this.codes) {
                if (!coverGroup.contains(code)) continue;
                ((VectorMetric.Count)areas.get(coverGroup)).add(p.getArea());
                continue block1;
            }
        }
        this.value = 0.0;
        for (Cover cover : this.codes) {
            double p = ((VectorMetric.Count)areas.get(cover)).get() / total;
            if (p == 0.0) continue;
            this.value += p * Math.log(p);
        }
        if (this.value != 0.0) {
            this.value *= -1.0;
        }
        if (Double.isNaN(this.value)) {
            this.value = Raster.getNoDataValue();
        }
    }
}

