/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.agriconnect.model;

import fr.inra.sad.bagap.apiland.analysis.matrix.pixel.Pixel2PixelMatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;

public class EcologicalModelCalculation
extends Pixel2PixelMatrixCalculation {
    private double intercept;
    private int[] codeHabitats;
    private double[] coeffHabitats;
    private double[] coeffMetrics;

    public EcologicalModelCalculation(double intercept, double[] coeffHabitats, int[] codeHabitats, double[] coeffMetrics, Matrix ... m) {
        super(m);
        this.intercept = intercept;
        this.codeHabitats = codeHabitats;
        this.coeffHabitats = coeffHabitats;
        this.coeffMetrics = coeffMetrics;
    }

    @Override
    public void doInit() {
    }

    @Override
    protected double treatPixel(Pixel p) {
        double coeffH = 1.0;
        double h = this.matrix().get(p);
        if (this.codeHabitats != null) {
            for (int c = 0; c < this.codeHabitats.length; ++c) {
                if ((double)this.codeHabitats[c] != h) continue;
                coeffH = this.coeffHabitats[c];
                break;
            }
        }
        if (coeffH != 0.0) {
            double[] valMetrics = new double[this.coeffMetrics.length];
            for (int i = 0; i < this.coeffMetrics.length; ++i) {
                valMetrics[i] = this.wholeMatrix()[i + 1].get(p);
            }
            return EcologicalModelCalculation.calculate(this.intercept, coeffH, this.coeffMetrics, valMetrics);
        }
        return Raster.getNoDataValue();
    }

    @Override
    public void doClose() {
        this.codeHabitats = null;
        this.coeffHabitats = null;
        this.coeffMetrics = null;
    }

    public static double calculate(double intercept, double coeffH, double[] coeffMetrics, double[] valMetrics) {
        double v = 0.0;
        v += intercept;
        for (int i = 0; i < coeffMetrics.length; ++i) {
            double vi = valMetrics[i];
            if (vi == (double)Raster.getNoDataValue()) {
                v = 0.0;
                break;
            }
            v += coeffMetrics[i] * vi;
        }
        v = v <= 0.0 ? (double)Raster.getNoDataValue() : Math.exp(v);
        return coeffH * v;
    }
}

