/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.io.OpenDialog;
import ij.plugin.filter.Analyzer;
import ij.text.TextPanel;
import java.awt.CheckboxMenuItem;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class TextWindow
extends Frame
implements ActionListener,
FocusListener,
ItemListener {
    static final String FONT_SIZE = "tw.font.size";
    static final String FONT_ANTI = "tw.font.anti";
    TextPanel textPanel;
    CheckboxMenuItem antialiased;
    int[] sizes = new int[]{9, 10, 11, 12, 13, 14, 16, 18, 20, 24, 36, 48, 60, 72};
    int fontSize = (int)Prefs.get("tw.font.size", 5.0);

    public TextWindow(String title, String data, int width, int height) {
        this(title, "", data, width, height);
    }

    public TextWindow(String title, String headings, String data, int width, int height) {
        super(title);
        Image img;
        this.enableEvents(64L);
        this.textPanel = new TextPanel(title);
        this.textPanel.setTitle(title);
        this.add("Center", this.textPanel);
        this.textPanel.setColumnHeadings(headings);
        if (data != null && !data.equals("")) {
            this.textPanel.append(data);
        }
        this.addKeyListener(this.textPanel);
        ImageJ ij = IJ.getInstance();
        if (ij != null && (img = ij.getIconImage()) != null) {
            try {
                this.setIconImage(img);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addFocusListener(this);
        this.addMenuBar();
        this.setFont();
        WindowManager.addWindow(this);
        this.setSize(width, height);
        GUI.center(this);
        this.show();
    }

    public TextWindow(String path, int width, int height) {
        super("");
        this.enableEvents(64L);
        this.textPanel = new TextPanel();
        this.add("Center", this.textPanel);
        if (this.openFile(path)) {
            WindowManager.addWindow(this);
            this.setSize(width, height);
            this.show();
        } else {
            this.dispose();
        }
    }

    void addMenuBar() {
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        m.add(new MenuItem("Save As...", new MenuShortcut(83)));
        if (this.getTitle().equals("Results")) {
            m.addSeparator();
            m.add(new MenuItem("Set File Extension..."));
        }
        m.addActionListener(this);
        mb.add(m);
        m = new Menu("Edit");
        m.add(new MenuItem("Cut", new MenuShortcut(88)));
        m.add(new MenuItem("Copy", new MenuShortcut(67)));
        m.add(new MenuItem("Clear"));
        m.add(new MenuItem("Select All", new MenuShortcut(65)));
        if (this.getTitle().equals("Results")) {
            m.addSeparator();
            m.add(new MenuItem("Clear Results"));
            m.add(new MenuItem("Summarize"));
            m.add(new MenuItem("Set Measurements..."));
        }
        m.addActionListener(this);
        mb.add(m);
        m = new Menu("Font");
        m.add(new MenuItem("Make Text Smaller"));
        m.add(new MenuItem("Make Text Larger"));
        m.addSeparator();
        this.antialiased = new CheckboxMenuItem("Antialiased", Prefs.get(FONT_ANTI, IJ.isMacOSX()));
        this.antialiased.addItemListener(this);
        m.add(this.antialiased);
        m.add(new MenuItem("Save Settings"));
        m.addActionListener(this);
        mb.add(m);
        this.setMenuBar(mb);
    }

    public void append(String text) {
        this.textPanel.append(text);
    }

    void setFont() {
        this.textPanel.setFont(new Font("SanSerif", 0, this.sizes[this.fontSize]), this.antialiased.getState());
    }

    boolean openFile(String path) {
        OpenDialog od = new OpenDialog("Open Text File...", path);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return false;
        }
        path = String.valueOf(directory) + name;
        IJ.showStatus("Opening: " + path);
        try {
            BufferedReader r = new BufferedReader(new FileReader(String.valueOf(directory) + name));
            this.load(r);
            r.close();
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return true;
        }
        this.textPanel.setTitle(name);
        this.setTitle(name);
        IJ.showStatus("");
        return true;
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public void load(BufferedReader in) throws IOException {
        String s;
        boolean count = false;
        while ((s = in.readLine()) != null) {
            this.textPanel.appendLine(s);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals("Make Text Larger")) {
            this.changeFontSize(true);
        } else if (cmd.equals("Make Text Smaller")) {
            this.changeFontSize(false);
        } else if (cmd.equals("Save Settings")) {
            this.saveSettings();
        } else {
            this.textPanel.doCommand(cmd);
        }
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        int id = e.getID();
        if (id == 201) {
            this.close();
        } else if (id == 205) {
            WindowManager.setWindow(this);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.setFont();
    }

    public void close() {
        if (this.getTitle().equals("Results")) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            IJ.setTextPanel(null);
        }
        if (this.getTitle().equals("Log")) {
            IJ.debugMode = false;
            IJ.log("\\Closed");
        }
        this.setVisible(false);
        this.dispose();
        WindowManager.removeWindow(this);
        this.textPanel.flush();
    }

    void changeFontSize(boolean larger) {
        int in = this.fontSize++;
        if (larger) {
            if (this.fontSize == this.sizes.length) {
                this.fontSize = this.sizes.length - 1;
            }
        } else {
            --this.fontSize;
            if (this.fontSize < 0) {
                this.fontSize = 0;
            }
        }
        IJ.showStatus(String.valueOf(this.sizes[this.fontSize]) + " point");
        this.setFont();
    }

    void saveSettings() {
        Prefs.set(FONT_SIZE, this.fontSize);
        Prefs.set(FONT_ANTI, this.antialiased.getState());
        IJ.showStatus("Font settings saved (size=" + this.sizes[this.fontSize] + ", antialiased=" + this.antialiased.getState() + ")");
    }

    public void focusGained(FocusEvent e) {
        WindowManager.setWindow(this);
    }

    public void focusLost(FocusEvent e) {
    }
}

