/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.RollingBall;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class BackgroundSubtracter
implements PlugInFilter {
    private static int radius = 50;
    private static boolean whiteBackground = true;
    private ImagePlus imp;
    private boolean canceled;
    private int slice;
    private boolean invert;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(BackgroundSubtracter.class);
        this.imp = imp;
        if (imp != null) {
            this.showDialog();
            if (this.canceled) {
                return 4096;
            }
        }
        IJ.register(BackgroundSubtracter.class);
        return IJ.setupDialog(imp, 21);
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (this.slice > 1) {
            IJ.showStatus("Subtract Background: " + this.slice + "/" + this.imp.getStackSize());
        }
        if (ip instanceof ColorProcessor) {
            this.subtractRGBBackround((ColorProcessor)ip, radius);
        } else {
            this.subtractBackround(ip, radius);
        }
        if (this.slice == 1 && ip instanceof ShortProcessor) {
            this.imp.getProcessor().resetMinAndMax();
        }
    }

    public void showDialog() {
        GenericDialog gd = new GenericDialog("Subtract Background");
        gd.addNumericField("Rolling Ball Radius:", radius, 0);
        gd.addCheckbox("White Background", whiteBackground);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.canceled = true;
        } else {
            radius = (int)gd.getNextNumber();
            whiteBackground = gd.getNextBoolean();
        }
        boolean invertedLut = this.imp.isInvertedLut();
        this.invert = invertedLut && !whiteBackground || !invertedLut && whiteBackground;
    }

    public void subtractRGBBackround(ColorProcessor ip, int ballRadius) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        byte[] H = new byte[width * height];
        byte[] S = new byte[width * height];
        byte[] B = new byte[width * height];
        ip.getHSB(H, S, B);
        ByteProcessor brightness = new ByteProcessor(width, height, B, null);
        this.subtractBackround(brightness, radius);
        ip.setHSB(H, S, (byte[])brightness.getPixels());
    }

    public void subtractBackround(ImageProcessor ip, int ballRadius) {
        ImageProcessor background;
        if (this.imp != null) {
            this.imp.killRoi();
        } else {
            ip.resetRoi();
        }
        ip.setProgressBar(null);
        IJ.showProgress(0.0);
        if (this.invert) {
            ip.invert();
        }
        RollingBall ball = new RollingBall(ballRadius);
        ImageProcessor smallImage = this.shrinkImage(ip, ball.shrinkfactor);
        if (this.slice == 1) {
            IJ.showStatus("Rolling ball (" + ball.shrinkfactor + ")...");
        }
        if (ip instanceof ShortProcessor) {
            background = this.rollBall16(ball, ip, smallImage);
            this.interpolateBackground16(background, ball);
            this.extrapolateBackground16(background, ball);
        } else {
            background = this.rollBall(ball, ip, smallImage);
            this.interpolateBackground(background, ball);
            this.extrapolateBackground(background, ball);
        }
        IJ.showProgress(0.9);
        if (IJ.altKeyDown()) {
            new ImagePlus("background", background).show();
        }
        ip.copyBits(background, 0, 0, 4);
        if (this.invert) {
            ip.invert();
        }
        IJ.showProgress(1.0);
    }

    ImageProcessor rollBall(RollingBall ball, ImageProcessor image, ImageProcessor smallImage) {
        byte[] pixels = (byte[])smallImage.getPixels();
        byte[] patch = ball.data;
        int width = image.getWidth();
        int height = image.getHeight();
        int swidth = smallImage.getWidth();
        int sheight = smallImage.getHeight();
        ByteProcessor background = new ByteProcessor(width, height);
        byte[] backgroundpixels = (byte[])((ImageProcessor)background).getPixels();
        int shrinkfactor = ball.shrinkfactor;
        int leftroll = 0;
        int rightroll = width / shrinkfactor - 1;
        int toproll = 0;
        int bottomroll = height / shrinkfactor - 1;
        int left = 1;
        int right = rightroll - leftroll - 1;
        int top = 1;
        int bottom = bottomroll - toproll - 1;
        int smallimagewidth = swidth;
        int patchwidth = ball.patchwidth;
        int halfpatchwidth = patchwidth / 2;
        int ybackgrinc = shrinkfactor * width;
        int zctr = 0;
        int ypt = top;
        while (ypt <= bottom + patchwidth) {
            int xpt = left;
            while (xpt <= right + patchwidth) {
                int p1;
                int xpt2;
                int zmin = 255;
                int ballpt = 0;
                int ypt2 = ypt - patchwidth;
                int imgpt = ypt2 * smallimagewidth + xpt - patchwidth;
                while (ypt2 <= ypt) {
                    xpt2 = xpt - patchwidth;
                    while (xpt2 <= xpt) {
                        int p2;
                        int zdif;
                        if (xpt2 >= left && xpt2 <= right && ypt2 >= top && ypt2 <= bottom && (zdif = (pixels[p2 = imgpt] & 0xFF) - (zctr + (patch[p1 = ballpt] & 0xFF))) < zmin) {
                            zmin = zdif;
                        }
                        ++ballpt;
                        ++xpt2;
                        ++imgpt;
                    }
                    ++ypt2;
                    imgpt = imgpt - patchwidth - 1 + smallimagewidth;
                }
                if (zmin != 0) {
                    zctr += zmin;
                }
                int ptsbelowlastpatch = zmin < 0 ? halfpatchwidth : 0;
                int yval = ypt - patchwidth;
                ypt2 = 0;
                ballpt = 0;
                int ybackgrpt = (yval - top + 1) * ybackgrinc;
                while (ypt2 <= patchwidth) {
                    int xval = xpt - patchwidth + ptsbelowlastpatch;
                    xpt2 = ptsbelowlastpatch;
                    ballpt += ptsbelowlastpatch;
                    int backgrpt = ybackgrpt + (xval - left + 1) * shrinkfactor;
                    while (xpt2 <= patchwidth) {
                        if (xval >= left && xval <= right && yval >= top && yval <= bottom) {
                            p1 = ballpt;
                            int zadd = zctr + (patch[p1] & 0xFF);
                            if (zadd > (backgroundpixels[p1 = backgrpt] & 0xFF)) {
                                backgroundpixels[p1] = (byte)zadd;
                            }
                        }
                        ++ballpt;
                        ++xval;
                        ++xpt2;
                        backgrpt += shrinkfactor;
                    }
                    ++yval;
                    ++ypt2;
                    ybackgrpt += ybackgrinc;
                }
                ++xpt;
            }
            if (ypt % 20 == 0) {
                IJ.showProgress(0.2 + 0.6 * (double)ypt / (double)(bottom + patchwidth));
            }
            ++ypt;
        }
        return background;
    }

    ImageProcessor shrinkImage(ImageProcessor ip, int shrinkfactor) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int swidth = width / shrinkfactor;
        int sheight = height / shrinkfactor;
        ImageProcessor ip2 = ip.duplicate();
        ip2.smooth();
        IJ.showProgress(0.1);
        ImageProcessor smallImage = ip.createProcessor(swidth, sheight);
        int y = 0;
        while (y < sheight) {
            int x = 0;
            while (x < swidth) {
                int xmaskmin = shrinkfactor * x;
                int ymaskmin = shrinkfactor * y;
                int min = 65535;
                int j = 0;
                while (j < shrinkfactor) {
                    int k = 0;
                    while (k < shrinkfactor) {
                        int thispixel = ip2.getPixel(xmaskmin + j, ymaskmin + k);
                        if (thispixel < min) {
                            min = thispixel;
                        }
                        ++k;
                    }
                    ++j;
                }
                smallImage.putPixel(x, y, min);
                ++x;
            }
            ++y;
        }
        return smallImage;
    }

    void interpolateBackground(ImageProcessor background, RollingBall ball) {
        int width = background.getWidth();
        int height = background.getHeight();
        int shrinkfactor = ball.shrinkfactor;
        int leftroll = 0;
        int rightroll = width / shrinkfactor - 1;
        int toproll = 0;
        int bottomroll = height / shrinkfactor - 1;
        byte[] pixels = (byte[])background.getPixels();
        int vloc = 0;
        int j = 1;
        while (j <= bottomroll - toproll - 1) {
            int hloc = 0;
            vloc += shrinkfactor;
            int i = 1;
            while (i <= rightroll - leftroll) {
                int p;
                int bgnextptr = vloc * width + (hloc += shrinkfactor);
                int bglastptr = bgnextptr - shrinkfactor;
                int nextvalue = pixels[bgnextptr] & 0xFF;
                int lastvalue = pixels[bglastptr] & 0xFF;
                int ii = 1;
                while (ii <= shrinkfactor - 1) {
                    p = bgnextptr - ii;
                    pixels[p] = (byte)(lastvalue + (shrinkfactor - ii) * (nextvalue - lastvalue) / shrinkfactor);
                    ++ii;
                }
                ii = 0;
                while (ii <= shrinkfactor - 1) {
                    bglastptr = (vloc - shrinkfactor) * width + hloc - ii;
                    bgnextptr = vloc * width + hloc - ii;
                    lastvalue = pixels[bglastptr] & 0xFF;
                    nextvalue = pixels[bgnextptr] & 0xFF;
                    int vinc = 0;
                    int jj = 1;
                    while (jj <= shrinkfactor - 1) {
                        p = bgnextptr + (vinc -= width);
                        pixels[p] = (byte)(lastvalue + (shrinkfactor - jj) * (nextvalue - lastvalue) / shrinkfactor);
                        ++jj;
                    }
                    ++ii;
                }
                ++i;
            }
            ++j;
        }
    }

    void extrapolateBackground(ImageProcessor background, RollingBall ball) {
        int pvalue;
        int p;
        int edgeslope;
        int nextvalue;
        int lastvalue;
        int bgnextptr;
        int bglastptr;
        int width = background.getWidth();
        int height = background.getHeight();
        int shrinkfactor = ball.shrinkfactor;
        int leftroll = 0;
        int rightroll = width / shrinkfactor - 1;
        int toproll = 0;
        int bottomroll = height / shrinkfactor - 1;
        byte[] pixels = (byte[])background.getPixels();
        int hloc = shrinkfactor;
        while (hloc <= shrinkfactor * (rightroll - leftroll) - 1) {
            bglastptr = shrinkfactor * width + hloc;
            bgnextptr = (shrinkfactor + 1) * width + hloc;
            lastvalue = pixels[bglastptr] & 0xFF;
            nextvalue = pixels[bgnextptr] & 0xFF;
            edgeslope = nextvalue - lastvalue;
            p = bglastptr;
            pvalue = lastvalue;
            int jj = 1;
            while (jj <= shrinkfactor) {
                pixels[p -= width] = (pvalue -= edgeslope) < 0 ? 0 : (pvalue > 255 ? -1 : (byte)pvalue);
                ++jj;
            }
            bglastptr = (shrinkfactor * (bottomroll - toproll - 1) - 1) * width + hloc;
            bgnextptr = shrinkfactor * (bottomroll - toproll - 1) * width + hloc;
            lastvalue = pixels[bglastptr] & 0xFF;
            nextvalue = pixels[bgnextptr] & 0xFF;
            edgeslope = nextvalue - lastvalue;
            p = bgnextptr;
            pvalue = nextvalue;
            jj = 1;
            while (jj <= height - 1 - shrinkfactor * (bottomroll - toproll - 1)) {
                pixels[p += width] = (pvalue += edgeslope) < 0 ? 0 : (pvalue > 255 ? -1 : (byte)pvalue);
                ++jj;
            }
            ++hloc;
        }
        int vloc = 0;
        while (vloc < height) {
            bglastptr = vloc * width + shrinkfactor;
            bgnextptr = bglastptr + 1;
            lastvalue = pixels[bglastptr] & 0xFF;
            nextvalue = pixels[bgnextptr] & 0xFF;
            edgeslope = nextvalue - lastvalue;
            p = bglastptr;
            pvalue = lastvalue;
            int ii = 1;
            while (ii <= shrinkfactor) {
                pixels[--p] = (pvalue -= edgeslope) < 0 ? 0 : (pvalue > 255 ? -1 : (byte)pvalue);
                ++ii;
            }
            bgnextptr = vloc * width + shrinkfactor * (rightroll - leftroll - 1) - 1;
            bglastptr = bgnextptr - 1;
            lastvalue = pixels[bglastptr] & 0xFF;
            nextvalue = pixels[bgnextptr] & 0xFF;
            edgeslope = nextvalue - lastvalue;
            p = bgnextptr;
            pvalue = nextvalue;
            ii = 1;
            while (ii <= width - 1 - shrinkfactor * (rightroll - leftroll - 1) + 1) {
                pixels[++p] = (pvalue += edgeslope) < 0 ? 0 : (pvalue > 255 ? -1 : (byte)pvalue);
                ++ii;
            }
            ++vloc;
        }
    }

    ImageProcessor rollBall16(RollingBall ball, ImageProcessor image, ImageProcessor smallImage) {
        short[] pixels = (short[])smallImage.getPixels();
        byte[] patch = ball.data;
        int width = image.getWidth();
        int height = image.getHeight();
        int swidth = smallImage.getWidth();
        int sheight = smallImage.getHeight();
        ShortProcessor background = new ShortProcessor(width, height);
        short[] backgroundpixels = (short[])((ImageProcessor)background).getPixels();
        int shrinkfactor = ball.shrinkfactor;
        int leftroll = 0;
        int rightroll = width / shrinkfactor - 1;
        int toproll = 0;
        int bottomroll = height / shrinkfactor - 1;
        int left = 1;
        int right = rightroll - leftroll - 1;
        int top = 1;
        int bottom = bottomroll - toproll - 1;
        int smallimagewidth = swidth;
        int patchwidth = ball.patchwidth;
        int halfpatchwidth = patchwidth / 2;
        int ybackgrinc = shrinkfactor * width;
        int zctr = 0;
        int ypt = top;
        while (ypt <= bottom + patchwidth) {
            int xpt = left;
            while (xpt <= right + patchwidth) {
                int p1;
                int xpt2;
                int zmin = 65535;
                int ballpt = 0;
                int ypt2 = ypt - patchwidth;
                int imgpt = ypt2 * smallimagewidth + xpt - patchwidth;
                while (ypt2 <= ypt) {
                    xpt2 = xpt - patchwidth;
                    while (xpt2 <= xpt) {
                        int p2;
                        int zdif;
                        if (xpt2 >= left && xpt2 <= right && ypt2 >= top && ypt2 <= bottom && (zdif = (pixels[p2 = imgpt] & 0xFFFF) - (zctr + (patch[p1 = ballpt] & 0xFF))) < zmin) {
                            zmin = zdif;
                        }
                        ++ballpt;
                        ++xpt2;
                        ++imgpt;
                    }
                    ++ypt2;
                    imgpt = imgpt - patchwidth - 1 + smallimagewidth;
                }
                if (zmin != 0) {
                    zctr += zmin;
                }
                int ptsbelowlastpatch = zmin < 0 ? halfpatchwidth : 0;
                int yval = ypt - patchwidth;
                ypt2 = 0;
                ballpt = 0;
                int ybackgrpt = (yval - top + 1) * ybackgrinc;
                while (ypt2 <= patchwidth) {
                    int xval = xpt - patchwidth + ptsbelowlastpatch;
                    xpt2 = ptsbelowlastpatch;
                    ballpt += ptsbelowlastpatch;
                    int backgrpt = ybackgrpt + (xval - left + 1) * shrinkfactor;
                    while (xpt2 <= patchwidth) {
                        if (xval >= left && xval <= right && yval >= top && yval <= bottom) {
                            p1 = ballpt;
                            int zadd = zctr + (patch[p1] & 0xFF);
                            if (zadd > (backgroundpixels[p1 = backgrpt] & 0xFFFF)) {
                                backgroundpixels[p1] = (short)zadd;
                            }
                        }
                        ++ballpt;
                        ++xval;
                        ++xpt2;
                        backgrpt += shrinkfactor;
                    }
                    ++yval;
                    ++ypt2;
                    ybackgrpt += ybackgrinc;
                }
                ++xpt;
            }
            if (ypt % 20 == 0) {
                IJ.showProgress(0.2 + 0.6 * (double)ypt / (double)(bottom + patchwidth));
            }
            ++ypt;
        }
        return background;
    }

    void interpolateBackground16(ImageProcessor background, RollingBall ball) {
        int width = background.getWidth();
        int height = background.getHeight();
        int shrinkfactor = ball.shrinkfactor;
        int leftroll = 0;
        int rightroll = width / shrinkfactor - 1;
        int toproll = 0;
        int bottomroll = height / shrinkfactor - 1;
        short[] pixels = (short[])background.getPixels();
        int vloc = 0;
        int j = 1;
        while (j <= bottomroll - toproll - 1) {
            int hloc = 0;
            vloc += shrinkfactor;
            int i = 1;
            while (i <= rightroll - leftroll) {
                int p;
                int bgnextptr = vloc * width + (hloc += shrinkfactor);
                int bglastptr = bgnextptr - shrinkfactor;
                int nextvalue = pixels[bgnextptr] & 0xFFFF;
                int lastvalue = pixels[bglastptr] & 0xFFFF;
                int ii = 1;
                while (ii <= shrinkfactor - 1) {
                    p = bgnextptr - ii;
                    pixels[p] = (short)(lastvalue + (shrinkfactor - ii) * (nextvalue - lastvalue) / shrinkfactor);
                    ++ii;
                }
                ii = 0;
                while (ii <= shrinkfactor - 1) {
                    bglastptr = (vloc - shrinkfactor) * width + hloc - ii;
                    bgnextptr = vloc * width + hloc - ii;
                    lastvalue = pixels[bglastptr] & 0xFFFF;
                    nextvalue = pixels[bgnextptr] & 0xFFFF;
                    int vinc = 0;
                    int jj = 1;
                    while (jj <= shrinkfactor - 1) {
                        p = bgnextptr + (vinc -= width);
                        pixels[p] = (short)(lastvalue + (shrinkfactor - jj) * (nextvalue - lastvalue) / shrinkfactor);
                        ++jj;
                    }
                    ++ii;
                }
                ++i;
            }
            ++j;
        }
    }

    void extrapolateBackground16(ImageProcessor background, RollingBall ball) {
        int pvalue;
        int p;
        int edgeslope;
        int nextvalue;
        int lastvalue;
        int bgnextptr;
        int bglastptr;
        int width = background.getWidth();
        int height = background.getHeight();
        int shrinkfactor = ball.shrinkfactor;
        int leftroll = 0;
        int rightroll = width / shrinkfactor - 1;
        int toproll = 0;
        int bottomroll = height / shrinkfactor - 1;
        short[] pixels = (short[])background.getPixels();
        int hloc = shrinkfactor;
        while (hloc <= shrinkfactor * (rightroll - leftroll) - 1) {
            bglastptr = shrinkfactor * width + hloc;
            bgnextptr = (shrinkfactor + 1) * width + hloc;
            lastvalue = pixels[bglastptr] & 0xFFFF;
            nextvalue = pixels[bgnextptr] & 0xFFFF;
            edgeslope = nextvalue - lastvalue;
            p = bglastptr;
            pvalue = lastvalue;
            int jj = 1;
            while (jj <= shrinkfactor) {
                pixels[p -= width] = (pvalue -= edgeslope) < 0 ? 0 : (pvalue > 65535 ? -1 : (short)pvalue);
                ++jj;
            }
            bglastptr = (shrinkfactor * (bottomroll - toproll - 1) - 1) * width + hloc;
            bgnextptr = shrinkfactor * (bottomroll - toproll - 1) * width + hloc;
            lastvalue = pixels[bglastptr] & 0xFFFF;
            nextvalue = pixels[bgnextptr] & 0xFFFF;
            edgeslope = nextvalue - lastvalue;
            p = bgnextptr;
            pvalue = nextvalue;
            jj = 1;
            while (jj <= height - 1 - shrinkfactor * (bottomroll - toproll - 1)) {
                pixels[p += width] = (pvalue += edgeslope) < 0 ? 0 : (pvalue > 65535 ? -1 : (short)pvalue);
                ++jj;
            }
            ++hloc;
        }
        int vloc = 0;
        while (vloc < height) {
            bglastptr = vloc * width + shrinkfactor;
            bgnextptr = bglastptr + 1;
            lastvalue = pixels[bglastptr] & 0xFFFF;
            nextvalue = pixels[bgnextptr] & 0xFFFF;
            edgeslope = nextvalue - lastvalue;
            p = bglastptr;
            pvalue = lastvalue;
            int ii = 1;
            while (ii <= shrinkfactor) {
                pixels[--p] = (pvalue -= edgeslope) < 0 ? 0 : (pvalue > 65535 ? -1 : (short)pvalue);
                ++ii;
            }
            bgnextptr = vloc * width + shrinkfactor * (rightroll - leftroll - 1) - 1;
            bglastptr = bgnextptr - 1;
            lastvalue = pixels[bglastptr] & 0xFFFF;
            nextvalue = pixels[bgnextptr] & 0xFFFF;
            edgeslope = nextvalue - lastvalue;
            p = bgnextptr;
            pvalue = nextvalue;
            ii = 1;
            while (ii <= width - 1 - shrinkfactor * (rightroll - leftroll - 1) + 1) {
                pixels[++p] = (pvalue += edgeslope) < 0 ? 0 : (pvalue > 65535 ? -1 : (short)pvalue);
                ++ii;
            }
            ++vloc;
        }
    }
}

