/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;

public class SimpleCommands
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("unlock")) {
            this.unlock(imp);
        } else if (arg.equals("rename")) {
            this.rename(imp);
        }
    }

    void unlock(ImagePlus imp) {
        boolean wasUnlocked = imp.lockSilently();
        if (wasUnlocked) {
            IJ.showStatus("\"" + imp.getTitle() + "\" is not locked");
        } else {
            IJ.showStatus("\"" + imp.getTitle() + "\" is now unlocked");
            IJ.beep();
        }
        imp.unlock();
    }

    void rename(ImagePlus imp) {
        GenericDialog gd = new GenericDialog("Rename");
        gd.addStringField("Title:", imp.getTitle(), 30);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        imp.setTitle(gd.getNextString());
    }
}

