/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.FHT;
import ij.process.ImageProcessor;

public class FFTMath
implements PlugIn {
    private static final int CONJUGATE_MULTIPLY = 0;
    private static final int MULTIPLY = 1;
    private static final int DIVIDE = 2;
    private static String[] ops = new String[]{"Correlate", "Convolve", "Deconvolve"};
    private static int index1;
    private static int index2;
    private static int operation;
    private static boolean doInverse;
    private static String title;
    private ImagePlus imp1;
    private ImagePlus imp2;

    static {
        operation = 0;
        doInverse = true;
        title = "Result";
    }

    public void run(String arg) {
        if (this.showDialog()) {
            this.doMath(this.imp1, this.imp2);
        }
    }

    public boolean showDialog() {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.noImage();
            return false;
        }
        String[] titles = new String[wList.length];
        int i = 0;
        while (i < wList.length) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
            ++i;
        }
        if (index1 >= titles.length) {
            index1 = 0;
        }
        if (index2 >= titles.length) {
            index2 = 0;
        }
        GenericDialog gd = new GenericDialog("FFT Math");
        gd.addChoice("Image1: ", titles, titles[index1]);
        gd.addChoice("Operation:", ops, ops[operation]);
        gd.addChoice("Image2: ", titles, titles[index2]);
        gd.addStringField("Result:", title);
        gd.addCheckbox("Do Inverse Transform", doInverse);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        index1 = gd.getNextChoiceIndex();
        operation = gd.getNextChoiceIndex();
        index2 = gd.getNextChoiceIndex();
        title = gd.getNextString();
        doInverse = gd.getNextBoolean();
        String title1 = titles[index1];
        String title2 = titles[index2];
        this.imp1 = WindowManager.getImage(wList[index1]);
        this.imp2 = WindowManager.getImage(wList[index2]);
        return true;
    }

    public void doMath(ImagePlus imp1, ImagePlus imp2) {
        FHT h1;
        FHT h2 = null;
        ImageProcessor fht1 = (ImageProcessor)imp1.getProperty("FHT");
        if (fht1 != null) {
            h1 = new FHT(fht1);
        } else {
            IJ.showStatus("Converting to float");
            ImageProcessor ip1 = imp1.getProcessor();
            h1 = new FHT(ip1);
        }
        ImageProcessor fht2 = (ImageProcessor)imp2.getProperty("FHT");
        if (fht2 != null) {
            h2 = new FHT(fht2);
        } else {
            ImageProcessor ip2 = imp2.getProcessor();
            if (imp2 != imp1) {
                h2 = new FHT(ip2);
            }
        }
        if (!h1.powerOf2Size()) {
            IJ.error("FFT Math", "Images must be a power of 2 size (256x256, 512x512, etc.)");
            return;
        }
        if (imp1.getWidth() != imp2.getWidth()) {
            IJ.error("FFT Math", "Images must be the same size");
            return;
        }
        if (fht1 == null) {
            IJ.showStatus("Transform image1");
            h1.transform();
        }
        if (fht2 == null) {
            if (h2 == null) {
                h2 = new FHT(h1.duplicate());
            } else {
                IJ.showStatus("Transform image2");
                h2.transform();
            }
        }
        FHT result = null;
        switch (operation) {
            case 0: {
                IJ.showStatus("Complex conjugate multiply");
                result = h1.conjugateMultiply(h2);
                break;
            }
            case 1: {
                IJ.showStatus("Fourier domain multiply");
                result = h1.multiply(h2);
                break;
            }
            case 2: {
                IJ.showStatus("Fourier domain divide");
                result = h1.divide(h2);
            }
        }
        if (doInverse) {
            IJ.showStatus("Inverse transform");
            result.inverseTransform();
            IJ.showStatus("Swap quadrants");
            result.swapQuadrants();
            IJ.showStatus("Display image");
            result.resetMinAndMax();
            new ImagePlus(title, result).show();
        } else {
            IJ.showStatus("Power spectrum");
            ImageProcessor ps = result.getPowerSpectrum();
            ImagePlus imp3 = new ImagePlus(title, ps.convertToFloat());
            result.quadrantSwapNeeded = true;
            imp3.setProperty("FHT", result);
            imp3.show();
        }
        IJ.showProgress(1.0);
    }
}

