/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackStatistics;

public class ContrastEnhancer
implements PlugIn,
Measurements {
    int max;
    int range;
    boolean classicEqualization;
    int stackSize;
    boolean updateSelectionOnly;
    static boolean equalize;
    static boolean normalize;
    static boolean processStack;
    static boolean useStackHistogram;
    static boolean entireImage;
    static double saturated;

    static {
        saturated = 0.5;
    }

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        this.stackSize = imp.getStackSize();
        imp.trimProcessor();
        if (!this.showDialog(imp)) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi != null) {
            roi.endPaste();
        }
        if (this.stackSize == 1) {
            Undo.setup(6, imp);
        } else {
            Undo.reset();
        }
        if (equalize) {
            this.equalize(imp);
        } else {
            this.stretchHistogram(imp, saturated);
        }
        if (equalize || normalize) {
            imp.getProcessor().resetMinAndMax();
        }
        imp.updateAndDraw();
    }

    boolean showDialog(ImagePlus imp) {
        int bitDepth = imp.getBitDepth();
        Roi roi = imp.getRoi();
        boolean areaRoi = roi != null && roi.isArea();
        GenericDialog gd = new GenericDialog("Enhance Contrast");
        gd.addNumericField("Saturated Pixels:", saturated, 1, 4, "%");
        if (bitDepth != 24) {
            gd.addCheckbox("Normalize", normalize);
        }
        if (areaRoi) {
            String label = bitDepth == 24 ? "Update Entire Image" : "Update All When Normalizing";
            gd.addCheckbox(label, entireImage);
        }
        gd.addCheckbox("Equalize Histogram", equalize);
        if (this.stackSize > 1) {
            gd.addCheckbox("Normalize_All " + this.stackSize + " Slices", processStack);
            gd.addCheckbox("Use Stack Histogram", useStackHistogram);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        saturated = gd.getNextNumber();
        normalize = bitDepth != 24 ? gd.getNextBoolean() : false;
        if (areaRoi) {
            entireImage = gd.getNextBoolean();
            boolean bl = this.updateSelectionOnly = !entireImage;
            if (!normalize && bitDepth != 24) {
                this.updateSelectionOnly = false;
            }
        }
        equalize = gd.getNextBoolean();
        processStack = this.stackSize > 1 ? gd.getNextBoolean() : false;
        boolean bl = useStackHistogram = this.stackSize > 1 ? gd.getNextBoolean() : false;
        if (saturated < 0.0) {
            saturated = 0.0;
        }
        if (saturated > 100.0) {
            saturated = 100.0;
        }
        if (processStack) {
            normalize = true;
        }
        return true;
    }

    public void stretchHistogram(ImagePlus imp, double saturated) {
        ImageStatistics stats = null;
        if (useStackHistogram) {
            stats = new StackStatistics(imp);
        }
        if (processStack) {
            ImageStack stack = imp.getStack();
            int i = 1;
            while (i <= this.stackSize) {
                IJ.showProgress(i, this.stackSize);
                ImageProcessor ip = stack.getProcessor(i);
                ip.setRoi(imp.getRoi());
                if (!useStackHistogram) {
                    stats = ImageStatistics.getStatistics(ip, 16, null);
                }
                this.stretchHistogram(ip, saturated, stats);
                ++i;
            }
        } else {
            ImageProcessor ip = imp.getProcessor();
            ip.setRoi(imp.getRoi());
            if (stats == null) {
                stats = ImageStatistics.getStatistics(ip, 16, null);
            }
            this.stretchHistogram(ip, saturated, stats);
        }
    }

    public void stretchHistogram(ImageProcessor ip, double saturated) {
        useStackHistogram = false;
        this.stretchHistogram(new ImagePlus("", ip), saturated);
    }

    public void stretchHistogram(ImageProcessor ip, double saturated, ImageStatistics stats) {
        int[] histogram = stats.histogram;
        int threshold = saturated > 0.0 ? (int)((double)stats.pixelCount * saturated / 200.0) : 0;
        int i = -1;
        boolean found = false;
        int count = 0;
        do {
            boolean bl = found = (count += histogram[++i]) > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        count = 0;
        do {
            boolean bl = found = (count += histogram[--i]) > threshold;
        } while (!found && i > 0);
        int hmax = i;
        if (hmax > hmin) {
            double min = stats.histMin + (double)hmin * stats.binSize;
            double max = stats.histMin + (double)hmax * stats.binSize;
            if (!this.updateSelectionOnly) {
                ip.resetRoi();
            }
            if (normalize) {
                this.normalize(ip, min, max);
            } else if (this.updateSelectionOnly) {
                ImageProcessor mask = ip.getMask();
                if (mask != null) {
                    ip.snapshot();
                }
                ip.setMinAndMax(min, max);
                if (mask != null) {
                    ip.reset(mask);
                }
            } else {
                ip.setMinAndMax(min, max);
            }
        }
    }

    void normalize(ImageProcessor ip, double min, double max) {
        boolean min2 = false;
        int max2 = 255;
        int range = 256;
        if (ip instanceof ShortProcessor) {
            max2 = 65535;
            range = 65536;
        } else if (ip instanceof FloatProcessor) {
            this.normalizeFloat(ip, min, max);
        }
        int[] lut = new int[range];
        int i = 0;
        while (i < range) {
            lut[i] = (double)i <= min ? 0 : ((double)i >= max ? max2 : (int)(((double)i - min) / (max - min) * (double)max2));
            ++i;
        }
        this.applyTable(ip, lut);
    }

    void applyTable(ImageProcessor ip, int[] lut) {
        if (this.updateSelectionOnly) {
            ImageProcessor mask = ip.getMask();
            if (mask != null) {
                ip.snapshot();
            }
            ip.applyTable(lut);
            if (mask != null) {
                ip.reset(mask);
            }
        } else {
            ip.applyTable(lut);
        }
    }

    void normalizeFloat(ImageProcessor ip, double min, double max) {
        double scale = max > min ? 1.0 / (max - min) : 1.0;
        int size = ip.getWidth() * ip.getHeight();
        float[] pixels = (float[])ip.getPixels();
        int i = 0;
        while (i < size) {
            double v = (double)pixels[i] - min;
            if (v < 0.0) {
                v = 0.0;
            }
            if ((v *= scale) > 1.0) {
                v = 1.0;
            }
            pixels[i] = (float)v;
            ++i;
        }
    }

    public void equalize(ImagePlus imp) {
        if (imp.getBitDepth() == 32) {
            IJ.showMessage("Contrast Enhancer", "Equalization of 32-bit images not supported.");
            return;
        }
        this.classicEqualization = IJ.altKeyDown();
        if (processStack) {
            ImageStack stack = imp.getStack();
            int i = 1;
            while (i <= this.stackSize) {
                IJ.showProgress(i, this.stackSize);
                ImageProcessor ip = stack.getProcessor(i);
                this.equalize(ip);
                ++i;
            }
        } else {
            this.equalize(imp.getProcessor());
        }
    }

    public void equalize(ImageProcessor ip) {
        int[] histogram = ip.getHistogram();
        ip.resetRoi();
        if (ip instanceof ShortProcessor) {
            this.max = 65535;
            this.range = 65535;
        } else {
            this.max = 255;
            this.range = 255;
        }
        double sum = this.getWeightedValue(histogram, 0);
        int i = 1;
        while (i < this.max) {
            sum += 2.0 * this.getWeightedValue(histogram, i);
            ++i;
        }
        double scale = (double)this.range / (sum += this.getWeightedValue(histogram, this.max));
        int[] lut = new int[this.range + 1];
        lut[0] = 0;
        sum = this.getWeightedValue(histogram, 0);
        int i2 = 1;
        while (i2 < this.max) {
            double delta = this.getWeightedValue(histogram, i2);
            lut[i2] = (int)Math.round((sum += delta) * scale);
            sum += delta;
            ++i2;
        }
        lut[this.max] = this.max;
        this.applyTable(ip, lut);
    }

    private double getWeightedValue(int[] histogram, int i) {
        int h = histogram[i];
        if (h < 2 || this.classicEqualization) {
            return h;
        }
        return Math.sqrt(h);
    }
}

