/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;

public class CanvasResizer
implements PlugIn {
    boolean zeroFill = Prefs.get("resizer.zero", false);

    public void run(String arg) {
        int yOff;
        int xOff;
        boolean fIsStack = false;
        ImagePlus imp = IJ.getImage();
        int wOld = imp.getWidth();
        int hOld = imp.getHeight();
        ImageStack stackOld = imp.getStack();
        if (stackOld != null && stackOld.getSize() > 1) {
            fIsStack = true;
        }
        String[] sPositions = new String[]{"Top-Left", "Top-Center", "Top-Right", "Center-Left", "Center", "Center-Right", "Bottom-Left", "Bottom-Center", "Bottom-Right"};
        String strTitle = fIsStack ? "Resize Stack Canvas" : "Resize Image Canvas";
        GenericDialog gd = new GenericDialog(strTitle);
        gd.addNumericField("Width:", wOld, 0, 5, "pixels");
        gd.addNumericField("Height:", hOld, 0, 5, "pixels");
        gd.addChoice("Position:", sPositions, sPositions[4]);
        gd.addCheckbox("Zero Fill", this.zeroFill);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int wNew = (int)gd.getNextNumber();
        int hNew = (int)gd.getNextNumber();
        int iPos = gd.getNextChoiceIndex();
        this.zeroFill = gd.getNextBoolean();
        Prefs.set("resizer.zero", this.zeroFill);
        int xC = (wNew - wOld) / 2;
        int xR = wNew - wOld;
        int yC = (hNew - hOld) / 2;
        int yB = hNew - hOld;
        switch (iPos) {
            case 0: {
                xOff = 0;
                yOff = 0;
                break;
            }
            case 1: {
                xOff = xC;
                yOff = 0;
                break;
            }
            case 2: {
                xOff = xR;
                yOff = 0;
                break;
            }
            case 3: {
                xOff = 0;
                yOff = yC;
                break;
            }
            case 4: {
                xOff = xC;
                yOff = yC;
                break;
            }
            case 5: {
                xOff = xR;
                yOff = yC;
                break;
            }
            case 6: {
                xOff = 0;
                yOff = yB;
                break;
            }
            case 7: {
                xOff = xC;
                yOff = yB;
                break;
            }
            case 8: {
                xOff = xR;
                yOff = yB;
                break;
            }
            default: {
                xOff = xC;
                yOff = yC;
            }
        }
        if (fIsStack) {
            ImageStack stackNew = this.expandStack(stackOld, wNew, hNew, xOff, yOff);
            imp.setStack(null, stackNew);
        } else {
            if (!IJ.macroRunning()) {
                Undo.setup(4, imp);
            }
            ImageProcessor newIP = this.expandImage(imp.getProcessor(), wNew, hNew, xOff, yOff);
            imp.setProcessor(null, newIP);
            if (!IJ.macroRunning()) {
                Undo.setup(5, imp);
            }
        }
    }

    public ImageStack expandStack(ImageStack stackOld, int wNew, int hNew, int xOff, int yOff) {
        int nFrames = stackOld.getSize();
        ImageProcessor ipOld = stackOld.getProcessor(1);
        Color colorBack = Toolbar.getBackgroundColor();
        ImageStack stackNew = new ImageStack(wNew, hNew, stackOld.getColorModel());
        int i = 1;
        while (i <= nFrames) {
            IJ.showProgress((double)i / (double)nFrames);
            ImageProcessor ipNew = ipOld.createProcessor(wNew, hNew);
            if (this.zeroFill) {
                ipNew.setValue(0.0);
            } else {
                ipNew.setColor(colorBack);
            }
            ipNew.fill();
            ipNew.insert(stackOld.getProcessor(i), xOff, yOff);
            stackNew.addSlice(null, ipNew);
            ++i;
        }
        return stackNew;
    }

    public ImageProcessor expandImage(ImageProcessor ipOld, int wNew, int hNew, int xOff, int yOff) {
        ImageProcessor ipNew = ipOld.createProcessor(wNew, hNew);
        if (this.zeroFill) {
            ipNew.setValue(0.0);
        } else {
            ipNew.setColor(Toolbar.getBackgroundColor());
        }
        ipNew.fill();
        ipNew.insert(ipOld, xOff, yOff);
        return ipNew;
    }
}

