/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImageListener;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Macro;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.FreehandRoi;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.util.Properties;
import java.util.Vector;

public class ImagePlus
implements ImageObserver,
Measurements {
    public static final int GRAY8 = 0;
    public static final int GRAY16 = 1;
    public static final int GRAY32 = 2;
    public static final int COLOR_256 = 3;
    public static final int COLOR_RGB = 4;
    public boolean changes;
    protected Image img;
    protected ImageProcessor ip;
    protected ImageWindow win;
    protected Roi roi;
    protected int currentSlice;
    protected static final int OPENED = 0;
    protected static final int CLOSED = 1;
    protected static final int UPDATED = 2;
    protected boolean compositeImage;
    protected int width;
    protected int height;
    protected boolean locked = false;
    private ImageJ ij = IJ.getInstance();
    private String title;
    private String url;
    private FileInfo fileInfo;
    private int nSlices = 1;
    private int nChannels = 1;
    private int nFrames = 1;
    private int imageType = 0;
    private ImageStack stack;
    private static int currentID = -1;
    private int ID;
    private static Component comp;
    private boolean imageLoaded;
    private int imageUpdateY;
    private int imageUpdateW;
    private Properties properties;
    private long startTime;
    private Calibration calibration;
    private static Calibration globalCalibration;
    private boolean activated;
    private boolean ignoreFlush;
    private boolean errorLoadingImage;
    private static ImagePlus clipboard;
    private static Vector listeners;
    private static boolean inListener;
    private int[] pvalue = new int[4];
    private int savex;
    private int savey;

    public ImagePlus() {
        this.ID = --currentID;
        this.title = "null";
    }

    public ImagePlus(String title, Image img) {
        this.title = title;
        this.ID = --currentID;
        if (img != null) {
            this.setImage(img);
        }
    }

    public ImagePlus(String title, ImageProcessor ip) {
        this.setProcessor(title, ip);
        this.ID = --currentID;
    }

    public ImagePlus(String pathOrURL) {
        Opener opener = new Opener();
        ImagePlus imp = null;
        boolean isURL = pathOrURL.indexOf("://") > 0;
        imp = isURL ? opener.openURL(pathOrURL) : opener.openImage(pathOrURL);
        if (imp != null) {
            if (imp.getStackSize() > 1) {
                this.setStack(imp.getTitle(), imp.getStack());
            } else {
                this.setProcessor(imp.getTitle(), imp.getProcessor());
            }
            this.setCalibration(imp.getCalibration());
            this.properties = imp.getProperties();
            if (isURL) {
                this.url = pathOrURL;
            }
            this.ID = --currentID;
        }
    }

    public ImagePlus(String title, ImageStack stack) {
        this.setStack(title, stack);
        this.ID = --currentID;
    }

    public synchronized boolean lock() {
        if (this.locked) {
            IJ.beep();
            IJ.showStatus("\"" + this.title + "\" is locked");
            if (IJ.macroRunning()) {
                IJ.error("Image is locked");
                Macro.abort();
            }
            return false;
        }
        this.locked = true;
        if (IJ.debugMode) {
            IJ.log(String.valueOf(this.title) + ": lock");
        }
        return true;
    }

    public synchronized boolean lockSilently() {
        if (this.locked) {
            return false;
        }
        this.locked = true;
        if (IJ.debugMode) {
            IJ.log(String.valueOf(this.title) + ": lock silently");
        }
        return true;
    }

    public synchronized void unlock() {
        this.locked = false;
        if (IJ.debugMode) {
            IJ.log(String.valueOf(this.title) + ": unlock");
        }
    }

    private void waitForImage(Image img) {
        if (comp == null && (comp = IJ.getInstance()) == null) {
            comp = new Canvas();
        }
        this.imageLoaded = false;
        if (!comp.prepareImage(img, this)) {
            while (!this.imageLoaded && !this.errorLoadingImage) {
                IJ.wait(30);
                if (this.imageUpdateW <= 1) continue;
                double progress = (double)this.imageUpdateY / (double)this.imageUpdateW;
                if (!(progress < 1.0) && (progress = 1.0 - (progress - 1.0)) < 0.0) {
                    progress = 0.9;
                }
                IJ.showProgress(progress);
            }
            IJ.showProgress(1.0);
        }
    }

    public void draw() {
        if (this.win != null) {
            this.win.getCanvas().repaint();
        }
    }

    public void draw(int x, int y, int width, int height) {
        if (this.win != null) {
            ImageCanvas ic = this.win.getCanvas();
            double mag = ic.getMagnification();
            x = ic.screenX(x);
            y = ic.screenY(y);
            width = (int)((double)width * mag);
            height = (int)((double)height * mag);
            ic.repaint(x, y, width, height);
            if (listeners != null && this.roi != null && this.roi.getPasteMode() != -1) {
                this.notifyListeners(2);
            }
        }
    }

    public void updateAndDraw() {
        if (this.ip != null) {
            if (this.win != null) {
                this.win.getCanvas().setImageUpdated();
            }
            this.draw();
            if (listeners != null && !inListener) {
                this.notifyListeners(2);
            }
        }
    }

    public void repaintWindow() {
        if (this.win != null) {
            this.draw();
            this.win.repaint();
        }
    }

    public void updateAndRepaintWindow() {
        if (this.win != null) {
            this.updateAndDraw();
            this.win.repaint();
        }
    }

    public void updateImage() {
        if (this.ip != null) {
            this.img = this.ip.createImage();
        }
    }

    public void hide() {
        if (this.win == null) {
            Interpreter.removeBatchModeImage(this);
            return;
        }
        boolean unlocked = this.lockSilently();
        this.changes = false;
        this.win.close();
        this.win = null;
        if (unlocked) {
            this.unlock();
        }
    }

    public void close() {
        ImageWindow win = this.getWindow();
        if (win != null) {
            win.close();
        } else {
            if (WindowManager.getCurrentImage() == this) {
                WindowManager.setTempCurrentImage(null);
            }
            this.killRoi();
            Interpreter.removeBatchModeImage(this);
        }
    }

    public void show() {
        this.show("");
    }

    public void show(String statusMessage) {
        if (this.win != null) {
            return;
        }
        if (IJ.macroRunning() && this.ij == null || Interpreter.isBatchMode()) {
            WindowManager.setTempCurrentImage(this);
            Interpreter.addBatchModeImage(this);
            return;
        }
        if (Prefs.useInvertingLut && this.getBitDepth() == 8 && this.ip != null && !this.ip.isInvertedLut() && !this.ip.isColorLut()) {
            this.invertLookupTable();
        }
        this.img = this.getImage();
        if (this.img != null && this.width >= 0 && this.height >= 0) {
            this.activated = false;
            this.win = this.getStackSize() > 1 ? new StackWindow(this) : new ImageWindow(this);
            if (this.roi != null) {
                this.roi.setImage(this);
            }
            this.draw();
            IJ.showStatus(statusMessage);
            if (IJ.macroRunning()) {
                long start = System.currentTimeMillis();
                while (!this.activated) {
                    IJ.wait(5);
                    if (System.currentTimeMillis() - start <= 2000L) continue;
                    WindowManager.setTempCurrentImage(this);
                    break;
                }
            }
            this.notifyListeners(0);
        }
    }

    void invertLookupTable() {
        int nImages = this.getStackSize();
        this.ip.invertLut();
        if (nImages == 1) {
            this.ip.invert();
        } else {
            ImageStack stack2 = this.getStack();
            int i = 1;
            while (i <= nImages) {
                stack2.getProcessor(i).invert();
                ++i;
            }
            stack2.setColorModel(this.ip.getColorModel());
        }
    }

    public void setActivated() {
        this.activated = true;
    }

    public Image getImage() {
        if (this.img == null && this.ip != null) {
            this.img = this.ip.createImage();
        }
        return this.img;
    }

    public int getID() {
        return this.ID;
    }

    public void setImage(Image img) {
        BufferedImage bi;
        if (img instanceof BufferedImage && (bi = (BufferedImage)img).getType() == 11) {
            this.setProcessor(null, new ShortProcessor(bi));
            return;
        }
        this.roi = null;
        this.errorLoadingImage = false;
        this.waitForImage(img);
        if (this.errorLoadingImage) {
            throw new IllegalStateException("Error loading image");
        }
        this.img = img;
        int newWidth = img.getWidth(this.ij);
        int newHeight = img.getHeight(this.ij);
        boolean dimensionsChanged = newWidth != this.width || newHeight != this.height;
        this.width = newWidth;
        this.height = newHeight;
        this.ip = null;
        this.stack = null;
        LookUpTable lut = new LookUpTable(img);
        int type = lut.getMapSize() > 0 ? (lut.isGrayscale() ? 0 : 3) : 4;
        this.setType(type);
        this.setupProcessor();
        this.img = this.ip.createImage();
        if (this.win != null) {
            if (dimensionsChanged) {
                this.win = new ImageWindow(this);
            } else {
                this.repaintWindow();
            }
        }
    }

    public void setProcessor(String title, ImageProcessor ip) {
        int stackSize = this.getStackSize();
        if (stackSize > 1 && (ip.getWidth() != this.width || ip.getHeight() != this.height)) {
            throw new IllegalArgumentException("ip wrong size");
        }
        if (stackSize <= 1) {
            this.stack = null;
            this.currentSlice = 1;
        }
        this.setProcessor2(title, ip, null);
    }

    void setProcessor2(String title, ImageProcessor ip, ImageStack newStack) {
        boolean dimensionsChanged;
        if (title != null) {
            this.setTitle(title);
        }
        this.ip = ip;
        if (this.ij != null) {
            ip.setProgressBar(this.ij.getProgressBar());
        }
        int stackSize = 1;
        if (this.stack != null && this.currentSlice > (stackSize = this.stack.getSize())) {
            this.currentSlice = stackSize;
        }
        this.img = null;
        boolean bl = dimensionsChanged = this.width > 0 && this.height > 0 && (this.width != ip.getWidth() || this.height != ip.getHeight());
        if (dimensionsChanged) {
            this.roi = null;
        }
        int type = ip instanceof ByteProcessor ? 0 : (ip instanceof ColorProcessor ? 4 : (ip instanceof ShortProcessor ? 1 : 2));
        if (this.width == 0) {
            this.imageType = type;
        } else {
            this.setType(type);
        }
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        if (this.win != null) {
            if (dimensionsChanged && stackSize == 1) {
                this.win.updateImage(this);
            } else if (newStack == null) {
                this.repaintWindow();
            }
        }
    }

    public void setStack(String title, ImageStack stack) {
        boolean resetCurrentSlice;
        boolean stackSizeChanged;
        int stackSize = stack.getSize();
        if (stackSize == 0) {
            throw new IllegalArgumentException("Stack is empty");
        }
        if (this.compositeImage) {
            stackSize /= this.nChannels;
        }
        boolean bl = stackSizeChanged = this.stack != null && stackSize != this.getStackSize();
        if (this.currentSlice < 1) {
            this.currentSlice = 1;
        }
        boolean bl2 = resetCurrentSlice = this.currentSlice > stackSize;
        if (resetCurrentSlice) {
            this.currentSlice = stackSize;
        }
        ImageProcessor ip = stack.getProcessor(this.currentSlice);
        boolean dimensionsChanged = this.width > 0 && this.height > 0 && (this.width != ip.getWidth() || this.height != ip.getHeight());
        this.stack = stack;
        this.setProcessor2(title, ip, stack);
        if (this.win == null) {
            return;
        }
        if (stackSize == 1 && this.win instanceof StackWindow) {
            this.win = new ImageWindow(this, this.getCanvas());
        } else if (dimensionsChanged && !stackSizeChanged) {
            this.win.updateImage(this);
        } else if (stackSize > 1 && !(this.win instanceof StackWindow)) {
            this.win = new StackWindow(this, this.getCanvas());
        } else if (stackSize > 1 && dimensionsChanged) {
            this.win = new StackWindow(this);
        } else {
            this.repaintWindow();
        }
        if (resetCurrentSlice) {
            this.setSlice(this.currentSlice);
        }
    }

    public void setFileInfo(FileInfo fi) {
        if (fi != null) {
            fi.pixels = null;
        }
        this.fileInfo = fi;
    }

    public ImageWindow getWindow() {
        return this.win;
    }

    public void setWindow(ImageWindow win) {
        this.win = win;
    }

    public ImageCanvas getCanvas() {
        return this.win != null ? this.win.getCanvas() : null;
    }

    public void setColor(Color c) {
        if (this.ip != null) {
            this.ip.setColor(c);
        }
    }

    void setupProcessor() {
        if (this.imageType == 4) {
            if (this.ip == null || this.ip instanceof ByteProcessor) {
                this.ip = new ColorProcessor(this.getImage());
                if (IJ.debugMode) {
                    IJ.log(String.valueOf(this.title) + ": new ColorProcessor");
                }
            }
        } else if (this.ip == null || this.ip instanceof ColorProcessor) {
            this.ip = new ByteProcessor(this.getImage());
            if (IJ.debugMode) {
                IJ.log(String.valueOf(this.title) + ": new ByteProcessor");
            }
        }
        if (this.roi != null && this.roi.isArea()) {
            this.ip.setRoi(this.roi.getBounds());
        } else {
            this.ip.resetRoi();
        }
    }

    public boolean isProcessor() {
        return this.ip != null;
    }

    public ImageProcessor getProcessor() {
        if (this.ip == null && this.img == null) {
            return null;
        }
        this.setupProcessor();
        this.ip.setLineWidth(Line.getWidth());
        if (this.ij != null) {
            this.ip.setProgressBar(this.ij.getProgressBar());
        }
        return this.ip;
    }

    public synchronized void trimProcessor() {
        if (this.ip != null && !this.locked) {
            if (this.ip != null && IJ.debugMode) {
                IJ.log(String.valueOf(this.title) + ": trimProcessor");
            }
            this.ip.setPixels(this.ip.getPixels());
        }
    }

    public void killProcessor() {
    }

    public ImageProcessor getMask() {
        if (this.roi == null) {
            if (this.ip != null) {
                this.ip.resetRoi();
            }
            return null;
        }
        ImageProcessor mask = this.roi.getMask();
        if (mask == null) {
            return null;
        }
        if (this.ip != null) {
            this.ip.setMask(mask);
            this.ip.setRoi(this.roi.getBounds());
        }
        return mask;
    }

    public ImageStatistics getStatistics() {
        return this.getStatistics(27);
    }

    public ImageStatistics getStatistics(int mOptions) {
        return this.getStatistics(mOptions, 256, 0.0, 0.0);
    }

    public ImageStatistics getStatistics(int mOptions, int nBins) {
        return this.getStatistics(mOptions, nBins, 0.0, 0.0);
    }

    public ImageStatistics getStatistics(int mOptions, int nBins, double histMin, double histMax) {
        this.setupProcessor();
        if (this.roi != null && this.roi.isArea()) {
            this.ip.setRoi(this.roi);
        } else {
            this.ip.resetRoi();
        }
        this.ip.setHistogramSize(nBins);
        Calibration cal = this.getCalibration();
        if (this.getType() == 1 && (histMin != 0.0 || histMax != 0.0)) {
            histMin = cal.getRawValue(histMin);
            histMax = cal.getRawValue(histMax);
        }
        this.ip.setHistogramRange(histMin, histMax);
        ImageStatistics stats = ImageStatistics.getStatistics(this.ip, mOptions, cal);
        this.ip.setHistogramSize(256);
        this.ip.setHistogramRange(0.0, 0.0);
        return stats;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public String getShortTitle() {
        String title = this.getTitle();
        int index = title.indexOf(32);
        if (index > -1) {
            title = title.substring(0, index);
        }
        if ((index = title.lastIndexOf(46)) > 0) {
            title = title.substring(0, index);
        }
        return title;
    }

    public void setTitle(String title) {
        if (title == null) {
            return;
        }
        if (this.win != null) {
            if (this.ij != null) {
                Menus.updateWindowMenuItem(this.title, title);
            }
            String scale = "";
            double magnification = this.win.getCanvas().getMagnification();
            if (magnification != 1.0) {
                double percent = magnification * 100.0;
                scale = percent == (double)((int)percent) ? " (" + IJ.d2s(percent, 0) + "%)" : " (" + IJ.d2s(percent, 1) + "%)";
            }
            this.win.setTitle(String.valueOf(title) + scale);
        }
        this.title = title;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStackSize() {
        if (this.stack == null) {
            return 1;
        }
        int slices = this.stack.getSize();
        if (slices == 0) {
            slices = 1;
        }
        if (this.compositeImage) {
            slices /= this.nChannels;
        }
        return slices;
    }

    public int getImageStackSize() {
        if (this.stack == null) {
            return 1;
        }
        int slices = this.stack.getSize();
        if (slices == 0) {
            slices = 1;
        }
        return slices;
    }

    public void setDimensions(int nChannels, int nSlices, int nFrames) {
        if (nChannels * nSlices * nFrames != this.getImageStackSize() && this.ip != null) {
            throw new IllegalArgumentException("channels*slices*frames!=stackSize");
        }
        this.nChannels = nChannels;
        this.nSlices = nSlices;
        this.nFrames = nFrames;
    }

    public int getNChannels() {
        this.verifyDimensions();
        return this.nChannels;
    }

    public int getNSlices() {
        this.verifyDimensions();
        return this.nSlices;
    }

    public int getNFrames() {
        this.verifyDimensions();
        return this.nFrames;
    }

    public int[] getDimensions() {
        this.verifyDimensions();
        int[] d = new int[]{this.width, this.height, this.nChannels, this.nSlices, this.nFrames};
        return d;
    }

    void verifyDimensions() {
        int stackSize = this.getImageStackSize();
        if (this.nSlices == 1) {
            if (this.nChannels > 1 && this.nFrames == 1) {
                this.nChannels = stackSize;
            } else if (this.nFrames > 1 && this.nChannels == 1) {
                this.nFrames = stackSize;
            }
        }
        if (this.nChannels * this.nSlices * this.nFrames != stackSize) {
            this.nSlices = stackSize;
            this.nChannels = 1;
            this.nFrames = 1;
        }
    }

    public int getType() {
        return this.imageType;
    }

    public int getBitDepth() {
        int bitDepth = 0;
        switch (this.imageType) {
            case 0: 
            case 3: {
                bitDepth = 8;
                break;
            }
            case 1: {
                bitDepth = 16;
                break;
            }
            case 2: {
                bitDepth = 32;
                break;
            }
            case 4: {
                bitDepth = 24;
            }
        }
        return bitDepth;
    }

    protected void setType(int type) {
        if (type < 0 || type > 4) {
            return;
        }
        int previousType = this.imageType;
        this.imageType = type;
        if (this.imageType != previousType) {
            if (this.win != null) {
                Menus.updateMenus();
            }
            this.getLocalCalibration().setImage(this);
        }
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public LookUpTable createLut() {
        if (this.getImage() != null) {
            return new LookUpTable(this.img);
        }
        return null;
    }

    public boolean isInvertedLut() {
        if (this.ip == null) {
            if (this.img == null) {
                return false;
            }
            this.setupProcessor();
        }
        return this.ip.isInvertedLut();
    }

    public int[] getPixel(int x, int y) {
        this.pvalue[3] = 0;
        this.pvalue[2] = 0;
        this.pvalue[1] = 0;
        this.pvalue[0] = 0;
        if (this.img == null) {
            return this.pvalue;
        }
        switch (this.imageType) {
            case 0: 
            case 3: {
                PixelGrabber pg;
                int index;
                if (this.ip != null) {
                    index = this.ip.getPixel(x, y);
                } else {
                    pg = new PixelGrabber(this.img, x, y, 1, 1, false);
                    try {
                        pg.grabPixels();
                    }
                    catch (InterruptedException e) {
                        return this.pvalue;
                    }
                    byte[] pixels8 = (byte[])pg.getPixels();
                    int n = index = pixels8 != null ? pixels8[0] & 0xFF : 0;
                }
                if (this.imageType != 3) {
                    this.pvalue[0] = index;
                    return this.pvalue;
                }
                this.pvalue[3] = index;
            }
            case 4: {
                int[] pixels32 = new int[1];
                if (this.win == null) break;
                PixelGrabber pg = new PixelGrabber(this.img, x, y, 1, 1, pixels32, 0, this.width);
                try {
                    pg.grabPixels();
                }
                catch (InterruptedException e) {
                    return this.pvalue;
                }
                int c = pixels32[0];
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                this.pvalue[0] = r;
                this.pvalue[1] = g;
                this.pvalue[2] = b;
                break;
            }
            case 1: 
            case 2: {
                if (this.ip == null) break;
                this.pvalue[0] = this.ip.getPixel(x, y);
            }
        }
        return this.pvalue;
    }

    public ImageStack createEmptyStack() {
        ColorModel cm = this.ip != null ? this.ip.getColorModel() : this.createLut().getColorModel();
        return new ImageStack(this.width, this.height, cm);
    }

    public ImageStack getStack() {
        ImageStack s;
        if (this.stack == null) {
            s = this.createEmptyStack();
            ImageProcessor ip2 = this.getProcessor();
            String info = (String)this.getProperty("Info");
            String label = info != null ? String.valueOf(this.getTitle()) + "\n" + info : null;
            s.addSlice(label, ip2);
            s.update(ip2);
        } else {
            s = this.stack;
            s.update(this.ip);
        }
        if (this.roi != null) {
            s.setRoi(this.roi.getBounds());
        }
        return s;
    }

    public ImageStack getImageStack() {
        if (this.stack == null) {
            return this.getStack();
        }
        this.stack.update(this.ip);
        return this.stack;
    }

    public int getCurrentSlice() {
        if (this.currentSlice < 1) {
            this.currentSlice = 1;
        }
        if (this.currentSlice > this.getStackSize()) {
            this.currentSlice = this.getStackSize();
        }
        return this.currentSlice;
    }

    public void killStack() {
        this.stack = null;
        this.trimProcessor();
    }

    public synchronized void setSlice(int index) {
        if (this.stack == null || index == this.currentSlice) {
            this.updateAndRepaintWindow();
            return;
        }
        if (index >= 1 && index <= this.stack.getSize()) {
            Roi roi = this.getRoi();
            if (roi != null) {
                roi.endPaste();
            }
            if (this.isProcessor()) {
                this.stack.setPixels(this.ip.getPixels(), this.currentSlice);
            }
            this.ip = this.getProcessor();
            this.currentSlice = index;
            Object pixels = this.stack.getPixels(this.currentSlice);
            if (pixels != null) {
                this.ip.setPixels(pixels);
            }
            if (this.win != null && this.win instanceof StackWindow) {
                ((StackWindow)this.win).updateSliceSelector();
            }
            if (IJ.spaceBarDown() && (this.imageType == 1 || this.imageType == 2)) {
                this.ip.resetMinAndMax();
                IJ.showStatus(String.valueOf(index) + ": min=" + this.ip.getMin() + ", max=" + this.ip.getMax());
            }
            if (!Interpreter.isBatchMode()) {
                this.updateAndRepaintWindow();
            }
        }
    }

    void undoFilter() {
        if (this.ip != null) {
            this.ip.reset();
            this.updateAndDraw();
        }
    }

    public Roi getRoi() {
        return this.roi;
    }

    public void setRoi(Roi newRoi) {
        if (newRoi == null) {
            this.killRoi();
            return;
        }
        if (newRoi.isVisible() && (newRoi = (Roi)newRoi.clone()) == null) {
            this.killRoi();
            return;
        }
        Rectangle bounds = newRoi.getBounds();
        if (bounds.width == 0 && bounds.height == 0) {
            this.killRoi();
            return;
        }
        this.roi = newRoi;
        if (this.ip != null) {
            this.ip.setMask(null);
            this.ip.setRoi(bounds);
        }
        this.roi.setImage(this);
        this.draw();
    }

    public void setRoi(int x, int y, int width, int height) {
        this.setRoi(new Rectangle(x, y, width, height));
    }

    public void setRoi(Rectangle r) {
        this.setRoi(new Roi(r.x, r.y, r.width, r.height));
    }

    public void createNewRoi(int sx, int sy) {
        this.killRoi();
        switch (Toolbar.getToolId()) {
            case 0: {
                this.roi = new Roi(sx, sy, this);
                break;
            }
            case 1: {
                this.roi = new OvalRoi(sx, sy, this);
                break;
            }
            case 2: 
            case 5: 
            case 14: {
                this.roi = new PolygonRoi(sx, sy, this);
                break;
            }
            case 3: 
            case 6: {
                this.roi = new FreehandRoi(sx, sy, this);
                break;
            }
            case 4: {
                this.roi = new Line(sx, sy, this);
                break;
            }
            case 9: {
                this.roi = new TextRoi(sx, sy, this);
                break;
            }
            case 7: {
                this.roi = new PointRoi(sx, sy, this);
                if (Prefs.pointAutoMeasure || Prefs.pointAutoNextSlice) {
                    IJ.run("Measure");
                }
                if (!Prefs.pointAutoNextSlice || this.getStackSize() <= 1) break;
                IJ.run("Next Slice [>]");
                this.killRoi();
            }
        }
    }

    public void killRoi() {
        if (this.roi != null) {
            this.saveRoi();
            this.roi = null;
            if (this.ip != null) {
                this.ip.resetRoi();
            }
            this.draw();
        }
    }

    public void saveRoi() {
        if (this.roi != null) {
            this.roi.endPaste();
            Rectangle r = this.roi.getBounds();
            if (r.width > 0 && r.height > 0) {
                Roi.previousRoi = (Roi)this.roi.clone();
                if (IJ.debugMode) {
                    IJ.log("saveRoi: " + this.roi);
                }
            }
        }
    }

    public void restoreRoi() {
        if (Roi.previousRoi != null) {
            Roi pRoi = Roi.previousRoi;
            Rectangle r = pRoi.getBounds();
            if (r.width <= this.width || r.height <= this.height) {
                this.roi = (Roi)pRoi.clone();
                this.roi.setImage(this);
                if (r.x >= this.width || r.y >= this.height || r.x + r.width <= 0 || r.y + r.height <= 0) {
                    this.roi.setLocation((this.width - r.width) / 2, (this.height - r.height) / 2);
                }
                this.draw();
            }
        }
    }

    public void revert() {
        boolean isFileInfo;
        if (this.getStackSize() > 1) {
            return;
        }
        FileInfo fi = this.getOriginalFileInfo();
        boolean bl = isFileInfo = fi != null && fi.fileFormat != 0;
        if (!isFileInfo && this.url == null) {
            return;
        }
        if (this.ij != null && this.changes && isFileInfo && !Interpreter.isBatchMode() && !IJ.macroRunning() && !IJ.altKeyDown() && !IJ.showMessageWithCancel("Revert?", "Revert to saved version of\n\"" + this.getTitle() + "\"?")) {
            return;
        }
        if (this.roi != null) {
            this.roi.endPaste();
        }
        this.trimProcessor();
        if (isFileInfo) {
            new FileOpener(fi).revertToSaved(this);
        } else if (this.url != null) {
            IJ.showStatus("Loading: " + this.url);
            Opener opener = new Opener();
            try {
                ImagePlus imp = opener.openURL(this.url);
                if (imp != null) {
                    this.setProcessor(null, imp.getProcessor());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getType() == 4 && this.getTitle().endsWith(".jpg")) {
                Opener.convertGrayJpegTo8Bits(this);
            }
        }
        if (Prefs.useInvertingLut && this.getBitDepth() == 8 && this.ip != null && !this.ip.isInvertedLut() && !this.ip.isColorLut()) {
            this.invertLookupTable();
        }
        if (this.getProperty("FHT") != null) {
            this.properties.remove("FHT");
            if (this.getTitle().startsWith("FFT of ")) {
                this.setTitle(this.getTitle().substring(6));
            }
        }
        this.repaintWindow();
        IJ.showStatus("");
        this.changes = false;
    }

    public FileInfo getFileInfo() {
        FileInfo fi = new FileInfo();
        fi.width = this.width;
        fi.height = this.height;
        fi.nImages = this.getStackSize();
        fi.whiteIsZero = this.isInvertedLut();
        fi.intelByteOrder = false;
        this.setupProcessor();
        fi.pixels = fi.nImages == 1 ? this.ip.getPixels() : this.stack.getImageArray();
        Calibration cal = this.getCalibration();
        if (cal.scaled()) {
            fi.pixelWidth = cal.pixelWidth;
            fi.pixelHeight = cal.pixelHeight;
            fi.unit = cal.getUnit();
        }
        if (fi.nImages > 1) {
            fi.pixelDepth = cal.pixelDepth;
        }
        fi.frameInterval = cal.frameInterval;
        if (cal.calibrated()) {
            fi.calibrationFunction = cal.getFunction();
            fi.coefficients = cal.getCoefficients();
            fi.valueUnit = cal.getValueUnit();
        }
        switch (this.imageType) {
            case 0: 
            case 3: {
                LookUpTable lut = this.createLut();
                fi.fileType = this.imageType == 3 || !lut.isGrayscale() ? 5 : 0;
                fi.lutSize = lut.getMapSize();
                fi.reds = lut.getReds();
                fi.greens = lut.getGreens();
                fi.blues = lut.getBlues();
                break;
            }
            case 1: {
                fi.fileType = 2;
                break;
            }
            case 2: {
                fi.fileType = 4;
                break;
            }
            case 4: {
                fi.fileType = 6;
            }
        }
        return fi;
    }

    public FileInfo getOriginalFileInfo() {
        return this.fileInfo;
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        this.imageUpdateY = y;
        this.imageUpdateW = w;
        if ((flags & 0x40) != 0) {
            this.errorLoadingImage = true;
            return false;
        }
        this.imageLoaded = (flags & 0xB0) != 0;
        return !this.imageLoaded;
    }

    public synchronized void flush() {
        Object[] arrays;
        this.notifyListeners(1);
        if (this.locked || this.ignoreFlush) {
            return;
        }
        if (this.ip != null) {
            this.ip.setPixels(null);
            this.ip = null;
        }
        if (this.roi != null) {
            this.roi.setImage(null);
        }
        if (this.stack != null && (arrays = this.stack.getImageArray()) != null) {
            int i = 0;
            while (i < arrays.length) {
                arrays[i] = null;
                ++i;
            }
        }
        this.img = null;
        System.gc();
    }

    public void setIgnoreFlush(boolean ignoreFlush) {
        this.ignoreFlush = ignoreFlush;
    }

    public ImagePlus createImagePlus() {
        ImagePlus imp2 = new ImagePlus();
        imp2.setType(this.getType());
        imp2.setCalibration(this.getCalibration());
        return imp2;
    }

    public void copyScale(ImagePlus imp) {
        if (imp != null && globalCalibration == null) {
            this.setCalibration(imp.getCalibration());
        }
    }

    public void startTiming() {
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Calibration getCalibration() {
        if (globalCalibration != null) {
            Calibration gc = globalCalibration.copy();
            gc.setImage(this);
            return gc;
        }
        if (this.calibration == null) {
            this.calibration = new Calibration(this);
        }
        return this.calibration;
    }

    public void setCalibration(Calibration cal) {
        if (cal == null) {
            this.calibration = null;
        } else {
            this.calibration = cal.copy();
            this.calibration.setImage(this);
        }
    }

    public void setGlobalCalibration(Calibration global) {
        globalCalibration = global == null ? null : global.copy();
    }

    public Calibration getGlobalCalibration() {
        return globalCalibration;
    }

    public Calibration getLocalCalibration() {
        if (this.calibration == null) {
            this.calibration = new Calibration(this);
        }
        return this.calibration;
    }

    public void mouseMoved(int x, int y) {
        IJ.showStatus(String.valueOf(this.getLocationAsString(x, y)) + this.getValueAsString(x, y));
        this.savex = x;
        this.savey = y;
    }

    public void updateStatusbarValue() {
        IJ.showStatus(String.valueOf(this.getLocationAsString(this.savex, this.savey)) + this.getValueAsString(this.savex, this.savey));
    }

    String getFFTLocation(int x, int y, Calibration cal) {
        double center = (double)this.width / 2.0;
        double r = Math.sqrt(((double)x - center) * ((double)x - center) + ((double)y - center) * ((double)y - center));
        if (r < 1.0) {
            r = 1.0;
        }
        double theta = Math.atan2((double)y - center, (double)x - center);
        if ((theta = theta * 180.0 / Math.PI) < 0.0) {
            theta += 360.0;
        }
        String s = "r=";
        s = cal.scaled() ? String.valueOf(s) + IJ.d2s((double)this.width / r * cal.pixelWidth, 2) + " " + cal.getUnit() + "/c (" + IJ.d2s(r, 0) + ")" : String.valueOf(s) + IJ.d2s((double)this.width / r, 2) + " p/c (" + IJ.d2s(r, 0) + ")";
        s = String.valueOf(s) + ", theta= " + IJ.d2s(theta, 2) + '\u00b0';
        return s;
    }

    public String getLocationAsString(int x, int y) {
        Calibration cal = this.getCalibration();
        if (this.getProperty("FHT") != null) {
            return this.getFFTLocation(x, this.height - y - 1, cal);
        }
        if (!IJ.altKeyDown()) {
            String s = " x=" + this.d2s(cal.getX(x)) + ", y=" + this.d2s(cal.getY(y, this.height));
            if (this.getStackSize() > 1) {
                s = String.valueOf(s) + ", z=" + this.d2s(cal.getZ(this.getCurrentSlice() - 1));
            }
            return s;
        }
        String s = " x=" + x + ", y=" + y;
        if (this.getStackSize() > 1) {
            s = String.valueOf(s) + ", z=" + (this.getCurrentSlice() - 1);
        }
        return s;
    }

    private String d2s(double n) {
        return n == (double)((int)n) ? Integer.toString((int)n) : IJ.d2s(n);
    }

    private String getValueAsString(int x, int y) {
        Calibration cal = this.getCalibration();
        int[] v = this.getPixel(x, y);
        int type = this.getType();
        switch (type) {
            case 0: 
            case 1: 
            case 3: {
                double cValue;
                if (type == 3) {
                    if (cal.getCValue(v[3]) == (double)v[3]) {
                        return ", index=" + v[3] + ", value=" + v[0] + "," + v[1] + "," + v[2];
                    }
                    v[0] = v[3];
                }
                if ((cValue = cal.getCValue(v[0])) == (double)v[0]) {
                    return ", value=" + v[0];
                }
                return ", value=" + IJ.d2s(cValue) + " (" + v[0] + ")";
            }
            case 2: {
                return ", value=" + Float.intBitsToFloat(v[0]);
            }
            case 4: {
                return ", value=" + v[0] + "," + v[1] + "," + v[2];
            }
        }
        return "";
    }

    public void copy(boolean cut) {
        Roi roi = this.getRoi();
        if (roi != null && !roi.isArea()) {
            IJ.error("Cut/Copy", "The Cut and Copy commands require\nan area selection, or no selection.");
            return;
        }
        String msg = cut ? "Cut" : "Copy";
        IJ.showStatus(String.valueOf(msg) + "ing...");
        ImageProcessor ip = this.getProcessor();
        Roi roi2 = null;
        ImageProcessor ip2 = ip.crop();
        if (roi != null && roi.getType() != 0) {
            roi2 = (Roi)roi.clone();
            Rectangle r = roi.getBounds();
            if (r.x < 0 || r.y < 0) {
                roi2.setLocation(Math.min(r.x, 0), Math.min(r.y, 0));
            }
        }
        clipboard = new ImagePlus("Clipboard", ip2);
        if (roi2 != null) {
            clipboard.setRoi(roi2);
        }
        if (cut) {
            ip.snapshot();
            ip.setColor(Toolbar.getBackgroundColor());
            ip.fill();
            if (roi != null && roi.getType() != 0) {
                this.getMask();
                ip.reset(ip.getMask());
            }
            this.setColor(Toolbar.getForegroundColor());
            Undo.setup(1, this);
            this.updateAndDraw();
        }
        int bytesPerPixel = 1;
        switch (clipboard.getType()) {
            case 1: {
                bytesPerPixel = 2;
                break;
            }
            case 2: 
            case 4: {
                bytesPerPixel = 4;
            }
        }
        IJ.showStatus(String.valueOf(msg) + ": " + clipboard.getWidth() * clipboard.getHeight() * bytesPerPixel / 1024 + "k");
    }

    public void paste() {
        if (clipboard == null) {
            return;
        }
        int cType = clipboard.getType();
        int iType = this.getType();
        boolean sameType = false;
        if (!(cType != 0 && cType != 3 || iType != 0 && iType != 3)) {
            sameType = true;
        } else if ((cType == 4 || cType == 0 || cType == 3) && iType == 4) {
            sameType = true;
        } else if (cType == 1 && iType == 1) {
            sameType = true;
        } else if (cType == 2 && iType == 2) {
            sameType = true;
        }
        if (!sameType) {
            IJ.error("Images must be the same type to paste.");
            return;
        }
        int w = clipboard.getWidth();
        int h = clipboard.getHeight();
        Roi cRoi = clipboard.getRoi();
        Rectangle r = null;
        Roi roi = this.getRoi();
        if (roi != null) {
            r = roi.getBounds();
        }
        if (w == this.width && h == this.height && (r == null || w != r.width || h != r.height)) {
            this.setRoi(0, 0, this.width, this.height);
            roi = this.getRoi();
            r = roi.getBounds();
        }
        if (r == null || r != null && (w != r.width || h != r.height)) {
            ImageCanvas ic = null;
            if (this.win != null) {
                ic = this.win.getCanvas();
            }
            Rectangle srcRect = ic != null ? ic.getSrcRect() : new Rectangle(0, 0, this.width, this.height);
            int xCenter = srcRect.x + srcRect.width / 2;
            int yCenter = srcRect.y + srcRect.height / 2;
            if (cRoi != null && cRoi.getType() != 0) {
                cRoi.setImage(this);
                cRoi.setLocation(xCenter - w / 2, yCenter - h / 2);
                this.setRoi(cRoi);
            } else {
                this.setRoi(xCenter - w / 2, yCenter - h / 2, w, h);
            }
            roi = this.getRoi();
        }
        if (IJ.macroRunning()) {
            int pasteMode = Roi.getCurrentPasteMode();
            boolean nonRect = roi.getType() != 0;
            ImageProcessor ip = this.getProcessor();
            if (nonRect) {
                ip.snapshot();
            }
            r = roi.getBounds();
            ip.copyBits(clipboard.getProcessor(), r.x, r.y, pasteMode);
            if (nonRect) {
                ip.reset(this.getMask());
            }
            this.updateAndDraw();
        } else if (roi != null) {
            roi.startPaste(clipboard);
            Undo.setup(3, this);
        }
        this.changes = true;
    }

    public static ImagePlus getClipboard() {
        return clipboard;
    }

    protected synchronized void notifyListeners(int id) {
        if (listeners == null) {
            return;
        }
        int i = 0;
        while (i < listeners.size()) {
            ImageListener listener = (ImageListener)listeners.elementAt(i);
            switch (id) {
                case 0: {
                    listener.imageOpened(this);
                    break;
                }
                case 1: {
                    listener.imageClosed(this);
                    break;
                }
                case 2: {
                    inListener = true;
                    listener.imageUpdated(this);
                    inListener = false;
                }
            }
            if (listeners == null) break;
            ++i;
        }
    }

    public static synchronized void addImageListener(ImageListener listener) {
        if (listeners == null) {
            listeners = new Vector();
        }
        listeners.addElement(listener);
    }

    public static synchronized void removeImageListener(ImageListener listener) {
        if (listeners == null) {
            return;
        }
        listeners.removeElement(listener);
        if (listeners.isEmpty()) {
            listeners = null;
        }
    }

    public String toString() {
        return "imp[" + this.getTitle() + " " + this.width + "x" + this.height + "x" + this.getStackSize() + "]";
    }
}

