/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseScaleOperationJAI;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.factory.GeoTools;
import org.geotools.image.ImageWorker;
import org.geotools.resources.coverage.CoverageUtilities;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class Affine
extends BaseScaleOperationJAI {
    private static final long serialVersionUID = 1699623079343108288L;

    public Affine() {
        super("Affine");
    }

    @Override
    protected RenderedImage createRenderedImage(ParameterBlockJAI parameters, RenderingHints hints) {
        RenderedImage source = (RenderedImage)parameters.getSource(0);
        if (hints == null) {
            hints = GeoTools.getDefaultHints().clone();
        }
        Object interpolation = parameters.getObjectParameter("interpolation") != null ? (Interpolation)parameters.getObjectParameter("interpolation") : (hints.get(JAI.KEY_INTERPOLATION) != null ? (Interpolation)hints.get(JAI.KEY_INTERPOLATION) : null);
        ROI roi = null;
        Object param = CoverageProcessor.getParameter(parameters, "roi");
        if (param != null) {
            roi = (ROI)param;
        }
        Range nodata = null;
        param = CoverageProcessor.getParameter(parameters, "nodata");
        if (param != null) {
            nodata = (Range)param;
        }
        ImageWorker worker = new ImageWorker(source);
        worker.setRenderingHints(hints);
        worker.setROI(roi);
        worker.setNoData(nodata);
        worker.affine((AffineTransform)parameters.getObjectParameter("transform"), (Interpolation)interpolation, (double[])parameters.getObjectParameter("backgroundValues"));
        return worker.getRenderedImage();
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockJAI parameters, ParameterValueGroup parameters2) {
        GridCoverage2D source = (GridCoverage2D)((Object)parameters2.parameter("source0").getValue());
        Affine.handleROINoDataInternal(parameters, source, "Affine", 3, 6);
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        Map props = sources[0].getProperties();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (props != null) {
            properties.putAll(props);
        }
        double[] background = (double[])parameters.parameters.getObjectParameter(2);
        if (parameters.parameters.getNumParameters() > 3 && parameters.parameters.getObjectParameter(6) != null) {
            CoverageUtilities.setNoDataProperty(properties, background);
        }
        PropertyGenerator propertyGenerator = null;
        if (data instanceof RenderedOp) {
            Object roiProp;
            String operationName = ((RenderedOp)data).getOperationName();
            if (operationName.equalsIgnoreCase("Affine") || operationName.equalsIgnoreCase("Scale") || operationName.equalsIgnoreCase("Translate")) {
                propertyGenerator = Affine.getOperationDescriptor(operationName).getPropertyGenerators("rendered")[0];
            }
            if (propertyGenerator != null && (roiProp = propertyGenerator.getProperty("roi", (Object)data)) != null && roiProp instanceof ROI) {
                CoverageUtilities.setROIProperty(properties, (ROI)roiProp);
            }
        }
        return properties;
    }
}

