/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.opengis.coverage.grid.Format;

public final class GridFormatFinder {
    private static FactoryRegistry registry;

    private GridFormatFinder() {
    }

    public static synchronized Set<GridFormatFactorySpi> getAvailableFormats() {
        GridFormatFinder.scanForPlugins();
        Iterator it = GridFormatFinder.getServiceRegistry().getServiceProviders(GridFormatFactorySpi.class, true);
        HashSet<GridFormatFactorySpi> formats = new HashSet<GridFormatFactorySpi>();
        while (it.hasNext()) {
            GridFormatFactorySpi spi = (GridFormatFactorySpi)it.next();
            if (!spi.isAvailable()) continue;
            formats.add(spi);
        }
        return Collections.unmodifiableSet(formats);
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(GridFormatFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(GridFormatFactorySpi.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        GridFormatFinder.getServiceRegistry().scanForPlugins();
    }

    public static Format[] getFormatArray() {
        Set<GridFormatFactorySpi> formats = GridFormatFinder.getAvailableFormats();
        ArrayList<AbstractGridFormat> formatSet = new ArrayList<AbstractGridFormat>(formats.size());
        for (GridFormatFactorySpi element : formats) {
            formatSet.add(element.createFormat());
        }
        return formatSet.toArray(new Format[formatSet.size()]);
    }

    public static synchronized Set<AbstractGridFormat> findFormats(Object o) {
        return GridFormatFinder.findFormats(o, GeoTools.getDefaultHints());
    }

    public static synchronized Set<AbstractGridFormat> findFormats(Object o, Hints hints) {
        Set<GridFormatFactorySpi> availaibleFormats = GridFormatFinder.getAvailableFormats();
        HashSet<AbstractGridFormat> formats = new HashSet<AbstractGridFormat>();
        for (GridFormatFactorySpi spi : availaibleFormats) {
            AbstractGridFormat retVal = spi.createFormat();
            if (!(retVal instanceof AbstractGridFormat) || !retVal.accepts(o, hints)) continue;
            formats.add(retVal);
        }
        return Collections.unmodifiableSet(formats);
    }

    public static synchronized AbstractGridFormat findFormat(Object o) {
        return GridFormatFinder.findFormat(o, GeoTools.getDefaultHints());
    }

    public static synchronized AbstractGridFormat findFormat(Object o, Hints hints) {
        Set<AbstractGridFormat> formats = GridFormatFinder.findFormats(o, hints);
        for (AbstractGridFormat f : formats) {
            if (!"GeoTIFF".equals(f.getName())) continue;
            return f;
        }
        Iterator<AbstractGridFormat> it = formats.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return new UnknownFormat();
    }
}

