/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.Prefs;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Recorder;
import ij.text.TextCanvas;
import ij.util.Tools;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class TextPanel
extends Panel
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
KeyListener,
ClipboardOwner,
ActionListener,
Runnable {
    static final int DOUBLE_CLICK_THRESHOLD = 650;
    int iGridWidth;
    int iGridHeight;
    int iX;
    int iY;
    String[] sColHead;
    Vector vData;
    int[] iColWidth;
    int iColCount;
    int iRowCount;
    int iRowHeight;
    int iFirstRow;
    Scrollbar sbHoriz;
    Scrollbar sbVert;
    int iSbWidth;
    int iSbHeight;
    boolean bDrag;
    int iXDrag;
    int iColDrag;
    boolean headings = true;
    String title = "";
    String labels;
    KeyListener keyListener;
    Cursor resizeCursor = new Cursor(11);
    Cursor defaultCursor = new Cursor(0);
    int selStart = -1;
    int selEnd = -1;
    int selOrigin = -1;
    int selLine = -1;
    TextCanvas tc = new TextCanvas(this);
    PopupMenu pm;
    boolean columnsManuallyAdjusted;
    long mouseDownTime;
    String filePath;

    public TextPanel() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.tc);
        this.sbHoriz = new Scrollbar(0);
        this.sbHoriz.addAdjustmentListener(this);
        this.add("South", this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.sbVert.addAdjustmentListener(this);
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            this.sbHoriz.addKeyListener(ij);
            this.sbVert.addKeyListener(ij);
        }
        this.add("East", this.sbVert);
        this.addPopupMenu();
    }

    public TextPanel(String title) {
        this();
        if (title.equals("Results")) {
            this.pm.addSeparator();
            this.addPopupItem("Clear Results");
            this.addPopupItem("Summarize");
            this.addPopupItem("Distribution...");
            this.addPopupItem("Set Measurements...");
        }
    }

    void addPopupMenu() {
        this.pm = new PopupMenu();
        this.addPopupItem("Save As...");
        this.pm.addSeparator();
        this.addPopupItem("Cut");
        this.addPopupItem("Copy");
        this.addPopupItem("Clear");
        this.addPopupItem("Select All");
        this.add(this.pm);
    }

    void addPopupItem(String s) {
        MenuItem mi = new MenuItem(s);
        mi.addActionListener(this);
        this.pm.add(mi);
    }

    public synchronized void setColumnHeadings(String labels) {
        boolean sameLabels = labels.equals(this.labels);
        this.labels = labels;
        if (labels.equals("")) {
            this.iColCount = 1;
            this.sColHead = new String[1];
            this.sColHead[0] = "";
        } else {
            this.sColHead = Tools.split(labels, "\t");
            this.iColCount = this.sColHead.length;
        }
        this.flush();
        this.vData = new Vector();
        if (this.iColWidth == null || this.iColWidth.length != this.iColCount || !sameLabels || this.iColCount == 1) {
            this.iColWidth = new int[this.iColCount];
            this.columnsManuallyAdjusted = false;
        }
        this.iRowCount = 0;
        this.resetSelection();
        this.adjustHScroll();
        this.tc.repaint();
    }

    public String getColumnHeadings() {
        return this.labels == null ? "" : this.labels;
    }

    public void setFont(Font font, boolean antialiased) {
        this.tc.fFont = font;
        this.tc.iImage = null;
        this.tc.fMetrics = null;
        this.tc.antialiased = antialiased;
        this.iColWidth[0] = 0;
        if (this.isShowing()) {
            this.updateDisplay();
        }
    }

    public void appendLine(String data) {
        if (this.vData == null) {
            this.setColumnHeadings("");
        }
        char[] chars = data.toCharArray();
        this.vData.addElement(chars);
        ++this.iRowCount;
        if (this.isShowing()) {
            if (this.iColCount == 1 && this.tc.fMetrics != null) {
                this.iColWidth[0] = Math.max(this.iColWidth[0], this.tc.fMetrics.charsWidth(chars, 0, chars.length));
                this.adjustHScroll();
            }
            this.updateDisplay();
        }
    }

    public void append(String data) {
        int p;
        if (data == null) {
            data = "null";
        }
        if (this.vData == null) {
            this.setColumnHeadings("");
        }
        do {
            if ((p = data.indexOf(10)) < 0) {
                this.appendWithoutUpdate(data);
                break;
            }
            this.appendWithoutUpdate(data.substring(0, p));
        } while (!(data = data.substring(p + 1)).equals(""));
        if (this.isShowing()) {
            this.updateDisplay();
        }
    }

    void appendWithoutUpdate(String data) {
        char[] chars = data.toCharArray();
        this.vData.addElement(chars);
        ++this.iRowCount;
    }

    void updateDisplay() {
        this.iY = this.iRowHeight * (this.iRowCount + 1);
        this.adjustVScroll();
        if (this.iColCount > 1 && this.iRowCount <= 10 && !this.columnsManuallyAdjusted) {
            this.iColWidth[0] = 0;
        }
        this.tc.repaint();
    }

    String getCell(int column, int row) {
        if (column < 0 || column >= this.iColCount || row < 0 || row >= this.iRowCount) {
            return null;
        }
        return new String(this.tc.getChars(column, row));
    }

    synchronized void adjustVScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        Dimension d = this.tc.getSize();
        int value = this.iY / this.iRowHeight;
        int visible = d.height / this.iRowHeight;
        int maximum = this.iRowCount + 1;
        if (visible < 0) {
            visible = 0;
        }
        if (visible > maximum) {
            visible = maximum;
        }
        if (value > maximum - visible) {
            value = maximum - visible;
        }
        this.sbVert.setValues(value, visible, 0, maximum);
        this.iY = this.iRowHeight * value;
    }

    synchronized void adjustHScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        Dimension d = this.tc.getSize();
        int w = 0;
        int i = 0;
        while (i < this.iColCount) {
            w += this.iColWidth[i];
            ++i;
        }
        this.iGridWidth = w;
        this.sbHoriz.setValues(this.iX, d.width, 0, this.iGridWidth);
        this.iX = this.sbHoriz.getValue();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
        this.tc.repaint();
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger() || e.isMetaDown()) {
            this.pm.show(e.getComponent(), x, y);
        } else if (e.isShiftDown()) {
            this.extendSelection(x, y);
        } else {
            this.select(x, y);
            this.handleDoubleClick();
        }
    }

    void handleDoubleClick() {
        if (this.selStart < 0 || this.selStart != this.selEnd || this.iColCount != 1) {
            return;
        }
        boolean doubleClick = System.currentTimeMillis() - this.mouseDownTime <= 650L;
        this.mouseDownTime = System.currentTimeMillis();
        if (doubleClick) {
            char[] chars = (char[])this.vData.elementAt(this.selStart);
            String s = new String(chars);
            int index = s.indexOf(": ");
            if (index > -1 && !s.endsWith(": ")) {
                s = s.substring(index + 2);
            }
            if (s.indexOf(File.separator) != -1 || s.indexOf(".") != -1) {
                this.filePath = s;
                Thread thread = new Thread((Runnable)this, "Open");
                thread.setPriority(thread.getPriority() - 1);
                thread.start();
            }
        }
    }

    public void run() {
        if (this.filePath != null) {
            IJ.open(this.filePath);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.bDrag) {
            this.setCursor(this.defaultCursor);
            this.bDrag = false;
        }
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (y <= this.iRowHeight) {
            int xb = x;
            x = x + this.iX - this.iGridWidth;
            int i = this.iColCount - 1;
            while (i >= 0) {
                if (x > -7 && x < 7) break;
                x += this.iColWidth[i];
                --i;
            }
            if (i >= 0) {
                if (!this.bDrag) {
                    this.setCursor(this.resizeCursor);
                    this.bDrag = true;
                    this.iXDrag = xb - this.iColWidth[i];
                    this.iColDrag = i;
                }
                return;
            }
        }
        if (this.bDrag) {
            this.setCursor(this.defaultCursor);
            this.bDrag = false;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (e.isPopupTrigger() || e.isMetaDown()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.bDrag && x < this.tc.getSize().width) {
            int w = x - this.iXDrag;
            if (w < 0) {
                w = 0;
            }
            this.iColWidth[this.iColDrag] = w;
            this.columnsManuallyAdjusted = true;
            this.adjustHScroll();
            this.tc.repaint();
        } else {
            this.extendSelection(x, y);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void addKeyListener(KeyListener listener) {
        this.keyListener = listener;
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (this.keyListener != null && key != 83 && key != 67 && key != 88 && key != 65) {
            this.keyListener.keyPressed(e);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        this.doCommand(cmd);
    }

    void doCommand(String cmd) {
        if (cmd == null) {
            return;
        }
        if (cmd.equals("Save As...")) {
            this.saveAs("");
        } else if (cmd.equals("Cut")) {
            this.cutSelection();
        } else if (cmd.equals("Copy")) {
            this.copySelection();
        } else if (cmd.equals("Clear")) {
            this.clearSelection();
        } else if (cmd.equals("Select All")) {
            this.selectAll();
        } else if (cmd.equals("Summarize")) {
            IJ.doCommand("Summarize");
        } else if (cmd.equals("Distribution...")) {
            IJ.doCommand("Distribution...");
        } else if (cmd.equals("Clear Results")) {
            IJ.doCommand("Clear Results");
        } else if (cmd.equals("Set Measurements...")) {
            IJ.doCommand("Set Measurements...");
        } else if (cmd.equals("Set File Extension...")) {
            IJ.doCommand("Input/Output...");
        }
    }

    public void lostOwnership(Clipboard clip, Transferable cont) {
    }

    void select(int x, int y) {
        Dimension d = this.tc.getSize();
        if (this.iRowHeight == 0 || x > d.width || y > d.height) {
            return;
        }
        int r = y / this.iRowHeight - 1 + this.iFirstRow;
        int lineWidth = this.iGridWidth;
        if (this.iColCount == 1 && this.tc.fMetrics != null && r >= 0 && r < this.iRowCount) {
            char[] chars = (char[])this.vData.elementAt(r);
            lineWidth = Math.max(this.tc.fMetrics.charsWidth(chars, 0, chars.length), this.iGridWidth);
        }
        if (r >= 0 && r < this.iRowCount && x < lineWidth) {
            this.selOrigin = r;
            this.selStart = r;
            this.selEnd = r;
        } else {
            this.resetSelection();
            this.selOrigin = r;
            if (r >= this.iRowCount) {
                this.selOrigin = this.iRowCount - 1;
            }
        }
        this.tc.repaint();
        this.selLine = r;
    }

    void extendSelection(int x, int y) {
        Dimension d = this.tc.getSize();
        if (this.iRowHeight == 0 || x > d.width || y > d.height) {
            return;
        }
        int r = y / this.iRowHeight - 1 + this.iFirstRow;
        if (r >= 0 && r < this.iRowCount) {
            if (r < this.selOrigin) {
                this.selStart = r;
                this.selEnd = this.selOrigin;
            } else {
                this.selStart = this.selOrigin;
                this.selEnd = r;
            }
        }
        this.tc.repaint();
        this.selLine = r;
    }

    public int copySelection() {
        if (this.selStart == -1 || this.selEnd == -1) {
            return this.copyAll();
        }
        StringBuffer sb = new StringBuffer();
        int i = this.selStart;
        while (i <= this.selEnd) {
            char[] chars = (char[])this.vData.elementAt(i);
            sb.append(chars);
            if (i < this.selEnd || this.selEnd > this.selStart) {
                sb.append('\n');
            }
            ++i;
        }
        String s = new String(sb);
        Clipboard clip = this.getToolkit().getSystemClipboard();
        if (clip == null) {
            return 0;
        }
        StringSelection cont = new StringSelection(s);
        clip.setContents(cont, this);
        if (s.length() > 0) {
            IJ.showStatus(String.valueOf(this.selEnd - this.selStart + 1) + " lines copied to clipboard");
            if (this.getParent() instanceof ImageJ) {
                Analyzer.setSaved();
            }
        }
        return s.length();
    }

    int copyAll() {
        this.selectAll();
        int count = this.selEnd - this.selStart;
        if (count > 0) {
            this.copySelection();
        }
        this.resetSelection();
        return count;
    }

    void cutSelection() {
        if (this.selStart == -1 || this.selEnd == -1) {
            this.selectAll();
        }
        this.copySelection();
        this.clearSelection();
    }

    public void clearSelection() {
        if (this.selStart == -1 || this.selEnd == -1) {
            if (this.getLineCount() > 0) {
                IJ.error("Selection required");
            }
            return;
        }
        if (this.selStart == 0 && this.selEnd == this.iRowCount - 1) {
            this.vData.removeAllElements();
            this.iRowCount = 0;
            if (IJ.isResultsWindow() && IJ.getTextPanel() == this) {
                Analyzer.setSaved();
                Analyzer.resetCounter();
            }
        } else {
            int count = this.selEnd - this.selStart + 1;
            int i = 0;
            while (i < count) {
                this.vData.removeElementAt(this.selStart);
                --this.iRowCount;
                ++i;
            }
            if (IJ.isResultsWindow() && IJ.getTextPanel() == this) {
                ResultsTable rt = ResultsTable.getResultsTable();
                int i2 = 0;
                while (i2 < count) {
                    rt.deleteRow(this.selStart);
                    ++i2;
                }
                rt.show("Results");
            }
        }
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.selLine = -1;
        this.adjustVScroll();
        this.tc.repaint();
    }

    public void clear() {
        if (this.vData == null) {
            return;
        }
        this.vData.removeAllElements();
        this.iRowCount = 0;
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.selLine = -1;
        this.adjustVScroll();
        this.tc.repaint();
    }

    public void selectAll() {
        if (this.selStart == 0 && this.selEnd == this.iRowCount - 1) {
            this.resetSelection();
            return;
        }
        this.selStart = 0;
        this.selEnd = this.iRowCount - 1;
        this.selOrigin = 0;
        this.tc.repaint();
        this.selLine = -1;
    }

    public void resetSelection() {
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.selLine = -1;
        if (this.iRowCount > 0) {
            this.tc.repaint();
        }
    }

    public void save(PrintWriter pw) {
        this.resetSelection();
        if (this.labels != null && !this.labels.equals("")) {
            pw.println(this.labels);
        }
        int i = 0;
        while (i < this.iRowCount) {
            char[] chars = (char[])this.vData.elementAt(i);
            pw.println(new String(chars));
            ++i;
        }
    }

    public boolean saveAs(String path) {
        boolean isResults;
        boolean bl = isResults = IJ.isResultsWindow() && IJ.getTextPanel() == this;
        if (path.equals("")) {
            IJ.wait(10);
            String ext = isResults ? Prefs.get("options.ext", ".xls") : ".txt";
            SaveDialog sd = new SaveDialog("Save as Text", this.title, ext);
            String file = sd.getFileName();
            if (file == null) {
                return false;
            }
            path = String.valueOf(sd.getDirectory()) + file;
        }
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(path);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            return true;
        }
        this.save(pw);
        pw.close();
        if (isResults) {
            Analyzer.setSaved();
            if (Recorder.record) {
                Recorder.record("saveAs", "Measurements", path);
            }
        } else if (Recorder.record) {
            Recorder.record("saveAs", "Text", path);
        }
        IJ.showStatus("");
        return true;
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        if (this.labels != null && !this.labels.equals("")) {
            sb.append(this.labels);
            sb.append('\n');
        }
        int i = 0;
        while (i < this.iRowCount) {
            char[] chars = (char[])this.vData.elementAt(i);
            sb.append(chars);
            sb.append('\n');
            ++i;
        }
        return new String(sb);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getLineCount() {
        return this.iRowCount;
    }

    public String getLine(int index) {
        if (index < 0 || index >= this.iRowCount) {
            throw new IllegalArgumentException("index out of range: " + index);
        }
        return new String((char[])this.vData.elementAt(index));
    }

    public void setLine(int index, String s) {
        if (index < 0 || index >= this.iRowCount) {
            throw new IllegalArgumentException("index out of range: " + index);
        }
        if (this.vData != null) {
            this.vData.setElementAt(s.toCharArray(), index);
            this.tc.repaint();
        }
    }

    public int getSelectionStart() {
        return this.selStart;
    }

    public int getSelectionEnd() {
        return this.selEnd;
    }

    void flush() {
        if (this.vData != null) {
            this.vData.removeAllElements();
        }
        this.vData = null;
    }
}

