/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.gui.ImageCanvas;
import ij.plugin.filter.LutWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class LutViewer
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 399;
    }

    public void run(ImageProcessor ip) {
        int y2;
        int x2;
        int xMargin = 35;
        int yMargin = 20;
        int width = 256;
        int height = 128;
        int barHeight = 12;
        LookUpTable lut = this.imp.createLut();
        int mapSize = lut.getMapSize();
        if (mapSize == 0) {
            return;
        }
        int imageWidth = width + 2 * xMargin;
        int imageHeight = height + 3 * yMargin;
        Image img = IJ.getInstance().createImage(imageWidth, imageHeight);
        Graphics g = img.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, imageWidth, imageHeight);
        g.setColor(Color.black);
        g.drawRect(xMargin, yMargin, width, height);
        byte[] reds = lut.getReds();
        byte[] greens = lut.getGreens();
        byte[] blues = lut.getBlues();
        double scale = 256.0 / (double)mapSize;
        boolean isGray = lut.isGrayscale();
        if (isGray) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.red);
        }
        int x1 = xMargin;
        int y1 = yMargin + height - (reds[0] & 0xFF) / 2;
        int i = 1;
        while (i < 256) {
            x2 = xMargin + i;
            y2 = yMargin + height - (reds[(int)((double)i / scale)] & 0xFF) / 2;
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
            ++i;
        }
        if (!isGray) {
            g.setColor(Color.green);
            x1 = xMargin;
            y1 = yMargin + height - (greens[0] & 0xFF) / 2;
            i = 1;
            while (i < 256) {
                x2 = xMargin + i;
                y2 = yMargin + height - (greens[(int)((double)i / scale)] & 0xFF) / 2;
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
                ++i;
            }
        }
        if (!isGray) {
            g.setColor(Color.blue);
            x1 = xMargin;
            y1 = yMargin + height - (blues[0] & 0xFF) / 2;
            i = 1;
            while (i < 255) {
                x2 = xMargin + i;
                y2 = yMargin + height - (blues[(int)((double)i / scale)] & 0xFF) / 2;
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
                ++i;
            }
        }
        int x = xMargin;
        int y = yMargin + height + 2;
        lut.drawColorBar(g, x, y, 256, barHeight);
        g.setColor(Color.black);
        g.drawString("0", x - 4, y += barHeight + 15);
        g.drawString("" + (mapSize - 1), x + width - 10, y);
        g.drawString("255", 7, yMargin + 4);
        g.dispose();
        ImagePlus imp = new ImagePlus("Look-Up Table", img);
        new LutWindow(imp, new ImageCanvas(imp), ip);
    }
}

