/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;

public class Zip_Reader
extends ImagePlus
implements PlugIn {
    private static final String TEMP_NAME = "temp.tif";
    private int width;
    private int height;
    private String tifName = "";
    private String dir;

    public void run(String arg) {
        ImagePlus imp;
        OpenDialog od = new OpenDialog("ZIP/TIFF Reader...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String path = String.valueOf(directory) + name;
        this.dir = IJ.getDirectory("temp");
        if (this.dir == null) {
            this.dir = IJ.getDirectory("startup");
        }
        if (this.dir == null) {
            this.dir = "";
        }
        IJ.showStatus("Opening: " + path);
        try {
            imp = this.openZip(path);
        }
        catch (Exception e) {
            IJ.error("ZIP Reader", e.getMessage());
            return;
        }
        if (imp != null) {
            this.setStack(this.tifName, imp.getStack());
            this.setCalibration(imp.getCalibration());
            if (imp.getStackSize() > 1) {
                int[] dim = imp.getDimensions();
                this.setDimensions(dim[2], dim[3], dim[4]);
            }
            FileInfo fi = new FileInfo();
            fi.fileFormat = 7;
            fi.fileName = name;
            fi.directory = directory;
            fi.width = this.getWidth();
            fi.height = this.getHeight();
            fi.nImages = this.getStackSize();
            this.setFileInfo(fi);
            Object info = imp.getProperty("Info");
            if (info != null) {
                this.setProperty("Info", info);
            }
            if (arg.equals("")) {
                this.show();
            }
        }
    }

    public ImagePlus openZip(String path) throws IOException {
        String name = this.extractFile(path);
        if (name == null) {
            return null;
        }
        this.tifName = name;
        ImagePlus imp = new Opener().openImage(this.dir, TEMP_NAME);
        new File(String.valueOf(this.dir) + TEMP_NAME).delete();
        return imp;
    }

    /*
     * Unable to fully structure code
     */
    String extractFile(String path) throws IOException {
        in = new ZipInputStream(new FileInputStream(path));
        out = new FileOutputStream(String.valueOf(this.dir) + "temp.tif");
        buf = new byte[1024];
        entry = in.getNextEntry();
        if (entry == null) {
            return null;
        }
        name = entry.getName();
        if (name.endsWith(".roi")) {
            out.close();
            in.close();
            IJ.runMacro("roiManager(\"Open\", getArgument());", path);
            return null;
        }
        if (name.endsWith(".tif") || name.endsWith(".dcm")) ** GOTO lbl19
        out.close();
        in.close();
        throw new IOException("This ZIP archive does not appear to contain a \nTIFF (\".tif\") or DICOM (\".dcm\") file, or ROIs (\".roi\").");
lbl-1000:
        // 1 sources

        {
            out.write(buf, 0, len);
lbl19:
            // 2 sources

            ** while ((len = in.read((byte[])buf)) > 0)
        }
lbl20:
        // 1 sources

        out.close();
        in.close();
        return name;
    }
}

