/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.StackProcessor;
import java.awt.Color;

public class Thresholder
implements PlugIn,
Measurements {
    private double minThreshold;
    private double maxThreshold;
    boolean autoThreshold;
    boolean skipDialog;
    static boolean fill1 = true;
    static boolean fill2 = true;
    static boolean useBW = true;
    boolean convertToMask;

    public void run(String arg) {
        this.convertToMask = arg.equals("mask");
        this.skipDialog = arg.equals("skip") || this.convertToMask;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (imp.getStackSize() == 1) {
            Undo.setup(4, imp);
            this.applyThreshold(imp);
            Undo.setup(5, imp);
        } else if (IJ.showMessageWithCancel("Convert to Mask", "Convert all images in stack to binary?")) {
            Undo.reset();
            this.applyThreshold(imp);
        }
    }

    void applyThreshold(ImagePlus imp) {
        if (!imp.lock()) {
            return;
        }
        imp.killRoi();
        ImageProcessor ip = imp.getProcessor();
        double saveMinThreshold = ip.getMinThreshold();
        double saveMaxThreshold = ip.getMaxThreshold();
        double saveMin = ip.getMin();
        double saveMax = ip.getMax();
        if (ip instanceof ByteProcessor) {
            saveMin = 0.0;
            saveMax = 255.0;
        }
        this.autoThreshold = saveMinThreshold == -808080.0;
        boolean useBlackAndWhite = true;
        if (this.skipDialog) {
            useBlackAndWhite = true;
            fill2 = true;
            fill1 = true;
        } else if (!this.autoThreshold) {
            GenericDialog gd = new GenericDialog("Apply Lut");
            gd.addCheckbox("Thresholded pixels to foreground color", fill1);
            gd.addCheckbox("Remaining pixels to background color", fill2);
            gd.addMessage("");
            gd.addCheckbox("Black foreground, white background", useBW);
            gd.showDialog();
            if (gd.wasCanceled()) {
                imp.unlock();
                return;
            }
            fill1 = gd.getNextBoolean();
            fill2 = gd.getNextBoolean();
            useBW = useBlackAndWhite = gd.getNextBoolean();
        } else {
            fill2 = true;
            fill1 = true;
        }
        if (imp.getType() != 0) {
            this.convertToByte(imp);
        }
        ip = imp.getProcessor();
        if (this.autoThreshold) {
            this.autoThreshold(imp);
        } else {
            if (Recorder.record) {
                Recorder.record("setThreshold", (int)saveMinThreshold, (int)saveMaxThreshold);
            }
            this.minThreshold = (saveMinThreshold - saveMin) / (saveMax - saveMin) * 255.0;
            this.maxThreshold = (saveMaxThreshold - saveMin) / (saveMax - saveMin) * 255.0;
        }
        ip.resetThreshold();
        int savePixel = ip.getPixel(0, 0);
        if (useBlackAndWhite) {
            ip.setColor(Color.black);
        } else {
            ip.setColor(Toolbar.getForegroundColor());
        }
        ip.drawPixel(0, 0);
        int fcolor = ip.getPixel(0, 0);
        if (useBlackAndWhite) {
            ip.setColor(Color.white);
        } else {
            ip.setColor(Toolbar.getBackgroundColor());
        }
        ip.drawPixel(0, 0);
        int bcolor = ip.getPixel(0, 0);
        ip.setColor(Toolbar.getForegroundColor());
        ip.putPixel(0, 0, savePixel);
        int[] lut = new int[256];
        int i = 0;
        while (i < 256) {
            lut[i] = (double)i >= this.minThreshold && (double)i <= this.maxThreshold ? (int)((byte)(fill1 ? fcolor : (byte)i)) : (int)((byte)(fill2 ? bcolor : (byte)i));
            ++i;
        }
        if (imp.getStackSize() > 1) {
            new StackProcessor(imp.getStack(), ip).applyTable(lut);
        } else {
            ip.applyTable(lut);
        }
        if (this.convertToMask && !imp.isInvertedLut()) {
            this.invertLut(imp);
            fcolor = 255 - fcolor;
            bcolor = 255 - bcolor;
        }
        if (fill1 = fill2 && (fcolor == 0 && bcolor == 255 || fcolor == 255 && bcolor == 0)) {
            imp.getProcessor().setThreshold(fcolor, fcolor, 2);
        }
        imp.updateAndRepaintWindow();
        imp.unlock();
    }

    void convertToByte(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        int currentSlice = imp.getCurrentSlice();
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = imp.createEmptyStack();
        int nSlices = imp.getStackSize();
        int i = 1;
        while (i <= nSlices) {
            String label = stack1.getSliceLabel(i);
            ip = stack1.getProcessor(i);
            ip.setMinAndMax(min, max);
            stack2.addSlice(label, ip.convertToByte(true));
            ++i;
        }
        imp.setStack(null, stack2);
        imp.setSlice(currentSlice);
        imp.setCalibration(imp.getCalibration());
    }

    void invertLut(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        ip.invertLut();
        int nImages = imp.getStackSize();
        if (nImages == 1) {
            ip.invert();
        } else {
            ImageStack stack = imp.getStack();
            int slice = 1;
            while (slice <= nImages) {
                stack.getProcessor(slice).invert();
                ++slice;
            }
            stack.setColorModel(ip.getColorModel());
        }
    }

    void autoThreshold(ImagePlus imp) {
        ImageStatistics stats = imp.getStatistics(24);
        ImageProcessor ip = imp.getProcessor();
        int threshold = ((ByteProcessor)ip).getAutoThreshold();
        if (stats.max - (double)stats.mode < (double)stats.mode - stats.min) {
            this.minThreshold = stats.min;
            this.maxThreshold = threshold;
        } else {
            this.minThreshold = threshold;
            this.maxThreshold = stats.max;
        }
    }
}

