/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.WindowManager;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Executer
implements Runnable {
    private static String previousCommand;
    private String command;
    private Thread thread;

    public Executer(String cmd) {
        this.command = cmd;
    }

    public Executer(String cmd, ImagePlus ignored) {
        if (cmd.startsWith("Repeat")) {
            this.command = previousCommand;
            IJ.setKeyUp(16);
        } else {
            this.command = cmd;
            if (!cmd.equals("Undo") && !cmd.equals("Close")) {
                previousCommand = cmd;
            }
        }
        IJ.resetEscape();
        this.thread = new Thread((Runnable)this, cmd);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void run() {
        block10: {
            if (this.command == null) {
                return;
            }
            try {
                if (Recorder.record) {
                    Recorder.setCommand(this.command);
                    this.runCommand(this.command);
                    Recorder.saveCommand();
                } else {
                    this.runCommand(this.command);
                }
            }
            catch (Throwable e) {
                IJ.showStatus("");
                IJ.showProgress(1.0);
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp != null) {
                    imp.unlock();
                }
                String msg = e.getMessage();
                if (e instanceof OutOfMemoryError) {
                    IJ.outOfMemory(this.command);
                }
                if (e instanceof RuntimeException && msg != null && msg.equals("Macro canceled")) break block10;
                CharArrayWriter caw = new CharArrayWriter();
                PrintWriter pw = new PrintWriter(caw);
                e.printStackTrace(pw);
                String s = caw.toString();
                if (IJ.isMacintosh()) {
                    if (s.indexOf("ThreadDeath") > 0) {
                        return;
                    }
                    s = Tools.fixNewLines(s);
                }
                if (IJ.getInstance() != null) {
                    new TextWindow("Exception", s, 350, 250);
                }
                IJ.log(s);
            }
        }
    }

    void runCommand(String cmd) {
        Hashtable table = Menus.getCommands();
        String className = (String)table.get(cmd);
        if (className != null) {
            int argStart;
            String arg = "";
            if (className.endsWith("\")") && (argStart = className.lastIndexOf("(\"")) > 0) {
                arg = className.substring(argStart + 2, className.length() - 2);
                className = className.substring(0, argStart);
            }
            if (IJ.shiftKeyDown() && className.startsWith("ij.plugin.Macro_Runner")) {
                IJ.open(String.valueOf(IJ.getDirectory("plugins")) + arg);
                IJ.setKeyUp(16);
            } else {
                IJ.runPlugIn(cmd, className, arg);
            }
        } else if (!MacroInstaller.runMacroCommand(cmd)) {
            IJ.error("Unrecognized command: " + cmd);
        }
    }

    public static String getCommand() {
        return previousCommand;
    }
}

