/*
 * Decompiled with CFR 0.152.
 */
package com.csvreader;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class CsvWriter {
    private static final String EMPTY = "";
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char QUOTE = '\"';
    private static final char COMMA = ',';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final int MAX_FILE_BUFFER_SIZE = 4096;
    private PrintWriter outputStream = null;
    private String fileName = null;
    private boolean firstColumn = true;
    private char delimiter = (char)44;
    private char textQualifier = (char)34;
    private boolean useTextQualifier = true;
    private Charset charset = null;
    private String singleQualifier = null;
    private String doubleQualifier = null;
    private boolean initialized = false;
    private boolean closed = false;

    public CsvWriter(String string, char c, Charset charset) {
        this();
        if (string == null) {
            throw new IllegalArgumentException("File name can not be null.");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Charset can not be null.");
        }
        this.fileName = string;
        this.delimiter = c;
        this.charset = charset;
    }

    public CsvWriter(String string) {
        this(string, ',', Charset.forName("ISO-8859-1"));
    }

    public CsvWriter(Writer writer, char c) {
        this();
        if (writer == null) {
            throw new IllegalArgumentException("Output stream can not be null.");
        }
        this.outputStream = new PrintWriter(writer);
        this.delimiter = c;
        this.initialized = true;
    }

    public CsvWriter(OutputStream outputStream, char c, Charset charset) {
        this(new OutputStreamWriter(outputStream, charset), c);
    }

    private CsvWriter() {
        this.initTextQualifier();
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char c) {
        this.delimiter = c;
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(char c) {
        this.textQualifier = c;
    }

    public boolean getUseTextQualifier() {
        return this.useTextQualifier;
    }

    public void setUseTextQualifier(boolean bl) {
        this.useTextQualifier = bl;
    }

    public void write(String string, boolean bl) throws FinalizedException, IOException {
        this.checkClosed();
        this.checkInit();
        if (string == null) {
            string = EMPTY;
        }
        int n = string.length();
        if (this.firstColumn) {
            if (n == 0) {
                this.outputStream.write(this.doubleQualifier);
            }
            this.firstColumn = false;
        } else {
            this.outputStream.write(this.delimiter);
        }
        if (n > 0) {
            boolean bl2 = false;
            if (!bl) {
                string = string.trim();
            } else if (this.useTextQualifier) {
                char c;
                char c2 = string.charAt(0);
                if (c2 == ' ' || c2 == '\t') {
                    bl2 = true;
                }
                if (!(bl2 || n <= 1 || (c = string.charAt(n - 1)) != ' ' && c != '\t')) {
                    bl2 = true;
                }
            }
            if (!(bl2 || string.indexOf(this.delimiter) <= -1 && string.indexOf(10) <= -1 && string.indexOf(13) <= -1 && string.indexOf(this.textQualifier) <= -1)) {
                bl2 = true;
            }
            if (bl2) {
                this.outputStream.write(this.textQualifier);
                string = string.replaceAll(this.singleQualifier, this.doubleQualifier);
            }
            this.outputStream.write(string);
            if (bl2) {
                this.outputStream.write(this.textQualifier);
            }
        }
    }

    public void write(String string) throws FinalizedException, IOException {
        this.write(string, false);
    }

    private void initTextQualifier() {
        this.singleQualifier = EMPTY;
        this.singleQualifier = this.singleQualifier + this.textQualifier;
        this.doubleQualifier = this.singleQualifier + this.singleQualifier;
    }

    public void endRecord() throws FinalizedException, IOException {
        this.checkClosed();
        this.checkInit();
        this.outputStream.println();
        this.firstColumn = true;
    }

    private void checkInit() throws IOException {
        if (!this.initialized) {
            if (this.fileName != null) {
                this.outputStream = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), this.charset));
            }
            this.initialized = true;
        }
    }

    public void flush() {
        this.outputStream.flush();
    }

    public void close() {
        if (!this.closed) {
            this.close(true);
            this.closed = true;
        }
    }

    protected void close(boolean bl) {
        if (bl) {
            this.charset = null;
        }
        try {
            if (this.initialized) {
                this.outputStream.close();
            }
            this.outputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkClosed() throws FinalizedException {
        if (this.closed) {
            throw new FinalizedException();
        }
    }

    protected void finalize() {
        this.close(false);
    }

    public class FinalizedException
    extends Exception {
        public FinalizedException() {
            super("Resources have already been freed.");
        }
    }
}

